/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.StreamingQueryEventType;
import org.apache.spark.connect.proto.StreamingQueryListenerEvent;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.connect.SparkSession;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\t\u0013\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019)\u0005\u0001)A\u0005k!9a\t\u0001a\u0001\n\u00139\u0005bB)\u0001\u0001\u0004%IA\u0015\u0005\u00071\u0002\u0001\u000b\u0015\u0002%\t\u000fe\u0003!\u0019!C\u00015\"1a\f\u0001Q\u0001\nmCQa\u0018\u0001\u0005\u0002\u0001DQ!\u0019\u0001\u0005\u0002\tDQ!\u001a\u0001\u0005\u0002\u0019DQ\u0001\u001b\u0001\u0005\u0002%DQ!\u001c\u0001\u0005\u00029DQ\u0001 \u0001\u0005\u0002uDq!!\u0001\u0001\t\u0003\t\u0019AA\rTiJ,\u0017-\\5oOF+XM]=MSN$XM\\3s\u0005V\u001c(BA\n\u0015\u0003\u001d\u0019wN\u001c8fGRT!!\u0006\f\u0002\u0007M\fHN\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011Q\u0005K\u0007\u0002M)\u0011qEF\u0001\tS:$XM\u001d8bY&\u0011\u0011F\n\u0002\b\u0019><w-\u001b8h\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\taS&D\u0001\u0013\u0013\tq#C\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003cI\u0002\"\u0001\f\u0001\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u00131L7\u000f^3oKJ\u001cX#A\u001b\u0011\u0007Yjt(D\u00018\u0015\tA\u0014(\u0001\u0006d_:\u001cWO\u001d:f]RT!AO\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002y\u0005!!.\u0019<b\u0013\tqtG\u0001\u000bD_BLxJ\\,sSR,\u0017I\u001d:bs2K7\u000f\u001e\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005R\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005\u0011\u000b%AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\u0002\u00151L7\u000f^3oKJ\u001c\b%A\bfq\u0016\u001cW\u000f^5p]RC'/Z1e+\u0005A\u0005cA\u0010J\u0017&\u0011!\n\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051{U\"A'\u000b\u00059[\u0014\u0001\u00027b]\u001eL!\u0001U'\u0003\rQC'/Z1e\u0003M)\u00070Z2vi&|g\u000e\u00165sK\u0006$w\fJ3r)\t\u0019f\u000b\u0005\u0002 )&\u0011Q\u000b\t\u0002\u0005+:LG\u000fC\u0004X\r\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'\u0001\tfq\u0016\u001cW\u000f^5p]RC'/Z1eA\u0005!An\\2l+\u0005Y\u0006C\u0001']\u0013\tiVJ\u0001\u0004PE*,7\r^\u0001\u0006Y>\u001c7\u000eI\u0001\u0006G2|7/\u001a\u000b\u0002'\u00061\u0011\r\u001d9f]\u0012$\"aU2\t\u000b\u0011\\\u0001\u0019A \u0002\u00111L7\u000f^3oKJ\faA]3n_Z,GCA*h\u0011\u0015!G\u00021\u0001@\u0003\u0011a\u0017n\u001d;\u0015\u0003)\u00042aH6@\u0013\ta\u0007EA\u0003BeJ\f\u00170\u0001\u000esK\u001eL7\u000f^3s'\u0016\u0014h/\u001a:TS\u0012,G*[:uK:,'\u000fF\u0001p!\r\u00018/^\u0007\u0002c*\u0011!OE\u0001\u0007G2LWM\u001c;\n\u0005Q\f(!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB\u0011aO_\u0007\u0002o*\u0011\u00010_\u0001\u0006aJ|Go\u001c\u0006\u0003'YI!a_<\u0003'\u0015CXmY;uKBc\u0017M\u001c*fgB|gn]3\u0002#E,XM]=Fm\u0016tG\u000fS1oI2,'\u000f\u0006\u0002T}\")qp\u0004a\u0001_\u0006!\u0011\u000e^3s\u0003%\u0001xn\u001d;U_\u0006cG\u000eF\u0002T\u0003\u000bAq!a\u0002\u0011\u0001\u0004\tI!A\u0003fm\u0016tG\u000f\u0005\u0003\u0002\f\u0005-b\u0002BA\u0007\u0003OqA!a\u0004\u0002&9!\u0011\u0011CA\u0012\u001d\u0011\t\u0019\"!\t\u000f\t\u0005U\u0011q\u0004\b\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111\u0004\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0012BA\r\u001b\u0013\t9\u0002$\u0003\u0002\u0016-%\u0011!\tF\u0005\u0004\u0003S\t\u0015AF*ue\u0016\fW.\u001b8h#V,'/\u001f'jgR,g.\u001a:\n\t\u00055\u0012q\u0006\u0002\u0006\u000bZ,g\u000e\u001e\u0006\u0004\u0003S\t\u0005")
public class StreamingQueryListenerBus
implements Logging {
    private final SparkSession sparkSession;
    private final CopyOnWriteArrayList<StreamingQueryListener> listeners;
    private Option<Thread> executionThread;
    private final Object lock;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CopyOnWriteArrayList<StreamingQueryListener> listeners() {
        return this.listeners;
    }

    private Option<Thread> executionThread() {
        return this.executionThread;
    }

    private void executionThread_$eq(Option<Thread> x$1) {
        this.executionThread = x$1;
    }

    public Object lock() {
        return this.lock;
    }

    public void close() {
        this.listeners().forEach(x$1 -> this.remove((StreamingQueryListener)x$1));
    }

    public void append(StreamingQueryListener listener) {
        Object object = new Object();
        try {
            Object object2 = this.lock();
            synchronized (object2) {
                this.listeners().add(listener);
                if (this.listeners().size() == 1) {
                    ObjectRef iter = ObjectRef.create((Object)Option$.MODULE$.empty());
                    this.liftedTree1$1(iter, listener, object);
                    this.executionThread_$eq((Option<Thread>)new Some((Object)new Thread(new Runnable(this, iter){
                        private final /* synthetic */ StreamingQueryListenerBus $outer;
                        private final ObjectRef iter$1;

                        public void run() {
                            this.$outer.queryEventHandler((CloseableIterator)((Option)this.iter$1.elem).get());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.iter$1 = iter$1;
                        }
                    })));
                    ((Thread)this.executionThread().get()).start();
                }
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public void remove(StreamingQueryListener listener) {
        Object object = new Object();
        try {
            Object object2 = this.lock();
            synchronized (object2) {
                if (this.listeners().size() == 1) {
                    Command.Builder cmdBuilder = Command.newBuilder();
                    cmdBuilder.getStreamingQueryListenerBusCommandBuilder().setRemoveListenerBusListener(true);
                    this.liftedTree2$1(cmdBuilder, object);
                    if (this.executionThread().isDefined()) {
                        ((Thread)this.executionThread().get()).interrupt();
                        this.executionThread_$eq((Option<Thread>)Option$.MODULE$.empty());
                    }
                }
                this.listeners().remove(listener);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public StreamingQueryListener[] list() {
        StreamingQueryListener[] streamingQueryListenerArray;
        Object object = this.lock();
        synchronized (object) {
            streamingQueryListenerArray = (StreamingQueryListener[])CollectionConverters$.MODULE$.ListHasAsScala(this.listeners()).asScala().toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
        }
        return streamingQueryListenerArray;
    }

    public CloseableIterator<ExecutePlanResponse> registerServerSideListener() {
        Command.Builder cmdBuilder = Command.newBuilder();
        cmdBuilder.getStreamingQueryListenerBusCommandBuilder().setAddListenerBusListener(true);
        Plan plan = Plan.newBuilder().setCommand(cmdBuilder.build()).build();
        CloseableIterator<ExecutePlanResponse> iterator = this.sparkSession.client().execute(plan);
        while (iterator.hasNext()) {
            ExecutePlanResponse response = (ExecutePlanResponse)iterator.next();
            if (!response.getStreamingQueryListenerEventsResult().hasListenerBusListenerAdded() || !response.getStreamingQueryListenerEventsResult().getListenerBusListenerAdded()) continue;
            return iterator;
        }
        return iterator;
    }

    public void queryEventHandler(CloseableIterator<ExecutePlanResponse> iter) {
        try {
            while (iter.hasNext()) {
                ExecutePlanResponse response = (ExecutePlanResponse)iter.next();
                List<StreamingQueryListenerEvent> listenerEvents = response.getStreamingQueryListenerEventsResult().getEventsList();
                listenerEvents.forEach(event -> {
                    StreamingQueryEventType streamingQueryEventType = event.getEventType();
                    if (StreamingQueryEventType.QUERY_PROGRESS_EVENT.equals(streamingQueryEventType)) {
                        this.postToAll((StreamingQueryListener.Event)StreamingQueryListener.QueryProgressEvent$.MODULE$.fromJson(event.getEventJson()));
                        return;
                    }
                    if (StreamingQueryEventType.QUERY_IDLE_EVENT.equals(streamingQueryEventType)) {
                        this.postToAll((StreamingQueryListener.Event)StreamingQueryListener.QueryIdleEvent$.MODULE$.fromJson(event.getEventJson()));
                        return;
                    }
                    if (StreamingQueryEventType.QUERY_TERMINATED_EVENT.equals(streamingQueryEventType)) {
                        this.postToAll((StreamingQueryListener.Event)StreamingQueryListener.QueryTerminatedEvent$.MODULE$.fromJson(event.getEventJson()));
                        return;
                    }
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown StreamingQueryListener event: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EVENT$.MODULE$, event)}))));
                });
            }
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "StreamingQueryListenerBus Handler thread received exception, all client side listeners are removed and handler thread is terminated.", (Throwable)e);
            Object object = this.lock();
            synchronized (object) {
                this.executionThread_$eq((Option<Thread>)Option$.MODULE$.empty());
                this.listeners().forEach(x$2 -> this.remove((StreamingQueryListener)x$2));
            }
        }
    }

    public void postToAll(StreamingQueryListener.Event event) {
        Object object = this.lock();
        synchronized (object) {
            this.listeners().forEach(listener -> {
                block6: {
                    try {
                        StreamingQueryListener.Event event = event;
                        if (event instanceof StreamingQueryListener.QueryStartedEvent) {
                            StreamingQueryListener.QueryStartedEvent queryStartedEvent = (StreamingQueryListener.QueryStartedEvent)event;
                            listener.onQueryStarted(queryStartedEvent);
                            break block6;
                        }
                        if (event instanceof StreamingQueryListener.QueryProgressEvent) {
                            StreamingQueryListener.QueryProgressEvent queryProgressEvent = (StreamingQueryListener.QueryProgressEvent)event;
                            listener.onQueryProgress(queryProgressEvent);
                            break block6;
                        }
                        if (event instanceof StreamingQueryListener.QueryIdleEvent) {
                            StreamingQueryListener.QueryIdleEvent queryIdleEvent = (StreamingQueryListener.QueryIdleEvent)event;
                            listener.onQueryIdle(queryIdleEvent);
                            break block6;
                        }
                        if (event instanceof StreamingQueryListener.QueryTerminatedEvent) {
                            StreamingQueryListener.QueryTerminatedEvent queryTerminatedEvent = (StreamingQueryListener.QueryTerminatedEvent)event;
                            listener.onQueryTerminated(queryTerminatedEvent);
                            break block6;
                        }
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown StreamingQueryListener event: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EVENT$.MODULE$, (Object)event)}))));
                    }
                    catch (Exception e) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Listener ", " threw an exception"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.LISTENER$.MODULE$, listener)}))), (Throwable)e);
                    }
                }
            });
        }
    }

    private final /* synthetic */ void liftedTree1$1(ObjectRef iter$1, StreamingQueryListener listener$1, Object nonLocalReturnKey1$1) {
        try {
            iter$1.elem = new Some(this.registerServerSideListener());
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to add the listener, please add it again.", (Throwable)e);
            this.listeners().remove(listener$1);
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    private final /* synthetic */ Seq liftedTree2$1(Command.Builder cmdBuilder$1, Object nonLocalReturnKey2$1) {
        Seq<ExecutePlanResponse> seq;
        try {
            seq = this.sparkSession.execute(cmdBuilder$1.build());
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Failed to remove the listener, please remove it again.", (Throwable)e);
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
        }
        return seq;
    }

    public StreamingQueryListenerBus(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.listeners = new CopyOnWriteArrayList();
        this.executionThread = Option$.MODULE$.empty();
        this.lock = new Object();
    }
}

