/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection;

import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.apache.spark.util.collection.PercentileHeap$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005]3QAD\b\u0001'eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006K\u0001!\tA\n\u0005\u0007U\u0001\u0001\u000b\u0011B\u0016\t\rI\u0002\u0001\u0015!\u0003,\u0011\u0019\u0019\u0004\u0001)Q\u0005i!)q\u0007\u0001C\u0001q!)\u0011\b\u0001C\u0001u!)a\b\u0001C\u0001\u007f!)\u0001\t\u0001C\u0001\u0003\u001eAqiDA\u0001\u0012\u0003\u0019\u0002J\u0002\u0005\u000f\u001f\u0005\u0005\t\u0012A\nJ\u0011\u0015)3\u0002\"\u0001K\u0011\u001dY5\"%A\u0005\u00021\u0013a\u0002U3sG\u0016tG/\u001b7f\u0011\u0016\f\u0007O\u0003\u0002\u0011#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005I\u0019\u0012\u0001B;uS2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\n\u0003\u0001i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0017A\u00039fe\u000e,g\u000e^1hK\u000e\u0001\u0001CA\u000e$\u0013\t!CD\u0001\u0004E_V\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001dJ\u0003C\u0001\u0015\u0001\u001b\u0005y\u0001b\u0002\u0011\u0003!\u0003\u0005\rAI\u0001\nY\u0006\u0014x-\u001a%fCB\u00042\u0001\f\u0019#\u001b\u0005i#B\u0001\n/\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!M\u0017\u0003\u001bA\u0013\u0018n\u001c:jif\fV/Z;f\u0003%\u0019X.\u00197m\u0011\u0016\f\u0007/\u0001\u0006o_\u0016cW-\\3oiN\u0004\"aG\u001b\n\u0005Yb\"a\u0002\"p_2,\u0017M\\\u0001\bSN,U\u000e\u001d;z)\u0005!\u0014\u0001B:ju\u0016$\u0012a\u000f\t\u00037qJ!!\u0010\u000f\u0003\u0007%sG/\u0001\u0006qKJ\u001cWM\u001c;jY\u0016$\u0012AI\u0001\u0007S:\u001cXM\u001d;\u0015\u0005\t+\u0005CA\u000eD\u0013\t!ED\u0001\u0003V]&$\b\"\u0002$\n\u0001\u0004\u0011\u0013!\u0001=\u0002\u001dA+'oY3oi&dW\rS3baB\u0011\u0001fC\n\u0003\u0017i!\u0012\u0001S\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u00035S#A\t(,\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u0013Ut7\r[3dW\u0016$'B\u0001+\u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0003-F\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class PercentileHeap {
    private final double percentage;
    private final PriorityQueue<Object> largeHeap;
    private final PriorityQueue<Object> smallHeap;
    private boolean noElements;

    public static double $lessinit$greater$default$1() {
        return PercentileHeap$.MODULE$.$lessinit$greater$default$1();
    }

    public boolean isEmpty() {
        return this.noElements;
    }

    public int size() {
        return this.smallHeap.size() + this.largeHeap.size();
    }

    public double percentile() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("empty");
        }
        return BoxesRunTime.unboxToDouble((Object)this.largeHeap.peek());
    }

    public void insert(double x) {
        boolean growBot;
        if (this.isEmpty()) {
            this.largeHeap.offer(BoxesRunTime.boxToDouble((double)x));
            this.noElements = false;
            return;
        }
        double p = BoxesRunTime.unboxToDouble((Object)this.largeHeap.peek());
        boolean bl = growBot = (int)((double)(this.size() + 1) * this.percentage) > this.smallHeap.size();
        if (growBot) {
            if (x < p) {
                this.smallHeap.offer(BoxesRunTime.boxToDouble((double)(-x)));
                return;
            }
            this.largeHeap.offer(BoxesRunTime.boxToDouble((double)x));
            this.smallHeap.offer(BoxesRunTime.boxToDouble((double)(-BoxesRunTime.unboxToDouble((Object)this.largeHeap.poll()))));
            return;
        }
        if (x < p) {
            this.smallHeap.offer(BoxesRunTime.boxToDouble((double)(-x)));
            this.largeHeap.offer(BoxesRunTime.boxToDouble((double)(-BoxesRunTime.unboxToDouble((Object)this.smallHeap.poll()))));
            return;
        }
        this.largeHeap.offer(BoxesRunTime.boxToDouble((double)x));
    }

    public PercentileHeap(double percentage) {
        this.percentage = percentage;
        Predef$.MODULE$.assert(percentage > 0.0 && percentage < 1.0);
        this.largeHeap = new PriorityQueue();
        this.smallHeap = new PriorityQueue();
        this.noElements = true;
    }
}

