/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalLimitOptimizer
extends Transform {
    private final Logger LOG = LoggerFactory.getLogger((String)GlobalLimitOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        TableScanOperator ts;
        LimitOperator tempGlobalLimit;
        Context ctx = pctx.getContext();
        HashMap<String, TableScanOperator> topOps = pctx.getTopOps();
        GlobalLimitCtx globalLimitCtx = pctx.getGlobalLimitCtx();
        HashMap<String, SplitSample> nameToSplitSample = pctx.getNameToSplitSample();
        if (ctx.getTryCount() == 0 && topOps.size() == 1 && !globalLimitCtx.ifHasTransformOrUDTF() && nameToSplitSample.isEmpty() && (tempGlobalLimit = GlobalLimitOptimizer.checkQbpForGlobalLimit(ts = (TableScanOperator)topOps.values().iterator().next())) != null) {
            String alias;
            PrunedPartitionList partsList;
            LimitDesc tempGlobalLimitDesc = (LimitDesc)tempGlobalLimit.getConf();
            Table tab = ((TableScanDesc)ts.getConf()).getTableMetadata();
            Set<FilterOperator> filterOps = OperatorUtils.findOperators(ts, FilterOperator.class);
            if (!tab.isPartitioned()) {
                if (filterOps.size() == 0) {
                    Integer tempOffset = tempGlobalLimitDesc.getOffset();
                    globalLimitCtx.enableOpt(tempGlobalLimitDesc.getLimit(), tempOffset == null ? 0 : tempOffset);
                }
            } else if (this.onlyContainsPartnCols(tab, filterOps) && !(partsList = pctx.getPrunedPartitions(alias = (String)topOps.keySet().toArray()[0], ts)).hasUnknownPartitions()) {
                Integer tempOffset = tempGlobalLimitDesc.getOffset();
                globalLimitCtx.enableOpt(tempGlobalLimitDesc.getLimit(), tempOffset == null ? 0 : tempOffset);
            }
            if (globalLimitCtx.isEnable()) {
                this.LOG.info("Qualify the optimize that reduces input size for 'offset' for offset " + globalLimitCtx.getGlobalOffset());
                this.LOG.info("Qualify the optimize that reduces input size for 'limit' for limit " + globalLimitCtx.getGlobalLimit());
            }
        }
        return pctx;
    }

    private boolean onlyContainsPartnCols(Table table, Set<FilterOperator> filters) {
        for (FilterOperator filter : filters) {
            if (PartitionPruner.onlyContainsPartnCols(table, ((FilterDesc)filter.getConf()).getPredicate())) continue;
            return false;
        }
        return true;
    }

    private static LimitOperator checkQbpForGlobalLimit(TableScanOperator ts) {
        ImmutableSet searchedClasses = new ImmutableSet.Builder().add(ReduceSinkOperator.class).add(GroupByOperator.class).add(FilterOperator.class).add(LimitOperator.class).build();
        Multimap<Class<? extends Operator<?>>, Operator<?>> ops = OperatorUtils.classifyOperators(ts, searchedClasses);
        for (Operator op : ops.get(ReduceSinkOperator.class)) {
            ReduceSinkDesc reduceSinkConf = (ReduceSinkDesc)((ReduceSinkOperator)op).getConf();
            if (!reduceSinkConf.isOrdering() && !reduceSinkConf.isPartitioning()) continue;
            return null;
        }
        for (Operator op : ops.get(GroupByOperator.class)) {
            GroupByDesc groupByConf = (GroupByDesc)((GroupByOperator)op).getConf();
            if (!groupByConf.isAggregate() && !groupByConf.isDistinct()) continue;
            return null;
        }
        for (Operator op : ops.get(FilterOperator.class)) {
            FilterDesc filterConf = (FilterDesc)((FilterOperator)op).getConf();
            if (!filterConf.getIsSamplingPred()) continue;
            return null;
        }
        Collection limitOps = ops.get(LimitOperator.class);
        if (limitOps.size() == 1) {
            return (LimitOperator)limitOps.iterator().next();
        }
        if (limitOps.size() == 0) {
            return null;
        }
        return null;
    }
}

