/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta2.DeviceConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceConstraintFluent<A extends DeviceConstraintFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String distinctAttribute;
    private String matchAttribute;
    private List<String> requests = new ArrayList<String>();

    public DeviceConstraintFluent() {
    }

    public DeviceConstraintFluent(DeviceConstraint instance) {
        this.copyInstance(instance);
    }

    public A addAllToRequests(Collection<String> items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToRequests(String ... items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)((Object)this);
    }

    public A addToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.add(index, item);
        return (A)((Object)this);
    }

    protected void copyInstance(DeviceConstraint instance) {
        DeviceConstraint deviceConstraint = instance = instance != null ? instance : new DeviceConstraint();
        if (instance != null) {
            this.withDistinctAttribute(instance.getDistinctAttribute());
            this.withMatchAttribute(instance.getMatchAttribute());
            this.withRequests(instance.getRequests());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceConstraintFluent that = (DeviceConstraintFluent)((Object)o);
        if (!Objects.equals(this.distinctAttribute, that.distinctAttribute)) {
            return false;
        }
        if (!Objects.equals(this.matchAttribute, that.matchAttribute)) {
            return false;
        }
        if (!Objects.equals(this.requests, that.requests)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDistinctAttribute() {
        return this.distinctAttribute;
    }

    public String getFirstRequest() {
        return this.requests.get(0);
    }

    public String getLastRequest() {
        return this.requests.get(this.requests.size() - 1);
    }

    public String getMatchAttribute() {
        return this.matchAttribute;
    }

    public String getMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public String getRequest(int index) {
        return this.requests.get(index);
    }

    public List<String> getRequests() {
        return this.requests;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasDistinctAttribute() {
        return this.distinctAttribute != null;
    }

    public boolean hasMatchAttribute() {
        return this.matchAttribute != null;
    }

    public boolean hasMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRequests() {
        return this.requests != null && !this.requests.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.distinctAttribute, this.matchAttribute, this.requests, this.additionalProperties);
    }

    public A removeAllFromRequests(Collection<String> items) {
        if (this.requests == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromRequests(String ... items) {
        if (this.requests == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.distinctAttribute != null) {
            sb.append("distinctAttribute:");
            sb.append(this.distinctAttribute);
            sb.append(",");
        }
        if (this.matchAttribute != null) {
            sb.append("matchAttribute:");
            sb.append(this.matchAttribute);
            sb.append(",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withDistinctAttribute(String distinctAttribute) {
        this.distinctAttribute = distinctAttribute;
        return (A)((Object)this);
    }

    public A withMatchAttribute(String matchAttribute) {
        this.matchAttribute = matchAttribute;
        return (A)((Object)this);
    }

    public A withRequests(List<String> requests) {
        if (requests != null) {
            this.requests = new ArrayList<String>();
            for (String item : requests) {
                this.addToRequests(item);
            }
        } else {
            this.requests = null;
        }
        return (A)((Object)this);
    }

    public A withRequests(String ... requests) {
        if (this.requests != null) {
            this.requests.clear();
            this._visitables.remove((Object)"requests");
        }
        if (requests != null) {
            for (String item : requests) {
                this.addToRequests(item);
            }
        }
        return (A)((Object)this);
    }
}

