/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.LinearSVCModel$;
import org.apache.spark.ml.classification.LinearSVCModel$LinearSVCReader$;
import org.apache.spark.ml.classification.LinearSVCModel$LinearSVCWriter$;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.LinearSVCSummary;
import org.apache.spark.ml.classification.LinearSVCSummaryImpl;
import org.apache.spark.ml.classification.LinearSVCTrainingSummary;
import org.apache.spark.ml.classification.LinearSVCTrainingSummaryImpl;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple1;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r]e\u0001\u0002$H\u0001IC\u0001\"\u001c\u0001\u0003\u0006\u0004%\tE\u001c\u0005\n\u0003\u0017\u0001!\u0011!Q\u0001\n=D!\"a\u0004\u0001\u0005\u000b\u0007I\u0011AA\t\u0011%\t)\u0002\u0001B\u0001B\u0003%q\u000b\u0003\u0006\u0002\u001a\u0001\u0011)\u0019!C\u0001\u00037A!\"a\n\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011!\tY\u0003\u0001C\u0001\u000f\u00065\u0002\u0002CA\u0016\u0001\u0011\u0005\u0011*a\u000f\t\u0013\u0005u\u0002A1A\u0005B\u0005}\u0002\u0002CA%\u0001\u0001\u0006I!!\u0011\t\u0013\u00055\u0003A1A\u0005B\u0005}\u0002\u0002CA)\u0001\u0001\u0006I!!\u0011\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!I\u0011\u0011\r\u0001C\u0002\u0013%\u00111\r\u0005\t\u0003W\u0002\u0001\u0015!\u0003\u0002f!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003W\u0003A\u0011IAW\u0011\u001d\t\u0019\f\u0001C!\u0003kCq!a0\u0001\t#\n\t\rC\u0004\u0002H\u0002!\t%!3\t\u0011\u0005u\u0007\u0001\"\u0011L\u0003?Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002t\u0002!\t%!>\t\u0011\u0005e\b\u0001\"\u0001L\u0003wD\u0001B!\u0007\u0001\t\u0003Z%1\u0004\u0005\t\u0005C\u0001A\u0011I&\u0003$\u001d9!\u0011J$\t\u0002\t-cA\u0002$H\u0011\u0003\u0011i\u0005C\u0004\u0002,u!\tAa\u001b\u0007\u000f\t5T\u0004Q%\u0003p!Q\u0011qB\u0010\u0003\u0016\u0004%\t!!\u0005\t\u0013\u0005UqD!E!\u0002\u00139\u0006BCA\r?\tU\r\u0011\"\u0001\u0002\u001c!Q\u0011qE\u0010\u0003\u0012\u0003\u0006I!!\b\t\u000f\u0005-r\u0004\"\u0001\u0003\u0006\"I\u0011qY\u0010\u0002\u0002\u0013\u0005!q\u0012\u0005\n\u0005+{\u0012\u0013!C\u0001\u0005/C\u0011Ba+ #\u0003%\tA!,\t\u0013\tEv$!A\u0005B\tM\u0006\"\u0003B`?\u0005\u0005I\u0011AA \u0011%\u0011\tmHA\u0001\n\u0003\u0011\u0019\rC\u0005\u0003J~\t\t\u0011\"\u0011\u0003L\"I!\u0011\\\u0010\u0002\u0002\u0013\u0005!1\u001c\u0005\n\u0005K|\u0012\u0011!C!\u0005OD\u0011Ba; \u0003\u0003%\tE!<\t\u0013\u0005Mx$!A\u0005B\t=\b\"\u0003By?\u0005\u0005I\u0011\tBz\u000f)\u001190HA\u0001\u0012\u0003I%\u0011 \u0004\u000b\u0005[j\u0012\u0011!E\u0001\u0013\nm\bbBA\u0016e\u0011\u00051\u0011\u0002\u0005\n\u0003g\u0014\u0014\u0011!C#\u0005_D\u0011ba\u00033\u0003\u0003%\ti!\u0004\t\u0013\rM!'!A\u0005\u0002\u000eU\u0001\"CB\u0014e\u0005\u0005I\u0011BB\u0015\u0011!\u0019\t$\bC\u0001\u0013\u000eM\u0002\u0002CB\";\u0011\u0005\u0011j!\u0012\t\u000f\rES\u0004\"\u0011\u0004T!91QL\u000f\u0005B\r}caBB3;\u0001i2q\r\u0005\n\u0007kb$\u0011!Q\u0001\nuCq!a\u000b=\t\u0003\u00199\bC\u0004\u0004~q\"\tfa \u0007\r\r\rU\u0004BBC\u0011\u001d\tY\u0003\u0011C\u0001\u0007\u000fC\u0011ba#A\u0005\u0004%IAa-\t\u0011\r5\u0005\t)A\u0005\u0005kCqa!\u0018A\t\u0003\u001ay\tC\u0005\u0004(u\t\t\u0011\"\u0003\u0004*\tqA*\u001b8fCJ\u001cfkQ'pI\u0016d'B\u0001%J\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!AS&\u0002\u00055d'B\u0001'N\u0003\u0015\u0019\b/\u0019:l\u0015\tqu*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0006\u0019qN]4\u0004\u0001M)\u0001a\u00150bOB!A+V,^\u001b\u00059\u0015B\u0001,H\u0005M\u0019E.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tA6,D\u0001Z\u0015\tQ\u0016*\u0001\u0004mS:\fGnZ\u0005\u00039f\u0013aAV3di>\u0014\bC\u0001+\u0001!\t!v,\u0003\u0002a\u000f\nyA*\u001b8fCJ\u001cfk\u0011)be\u0006l7\u000f\u0005\u0002cK6\t1M\u0003\u0002e\u0013\u0006!Q\u000f^5m\u0013\t17M\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\u00042A\u00195k\u0013\tI7M\u0001\nICN$&/Y5oS:<7+^7nCJL\bC\u0001+l\u0013\tawI\u0001\rMS:,\u0017M]*W\u0007R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7bef\f1!^5e+\u0005y\u0007C\u00019z\u001d\t\tx\u000f\u0005\u0002sk6\t1O\u0003\u0002u#\u00061AH]8pizR\u0011A^\u0001\u0006g\u000e\fG.Y\u0005\u0003qV\fa\u0001\u0015:fI\u00164\u0017B\u0001>|\u0005\u0019\u0019FO]5oO*\u0011\u00010\u001e\u0015\u0005\u0003u\f9\u0001E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003Y\u0015AC1o]>$\u0018\r^5p]&\u0019\u0011QA@\u0003\u000bMKgnY3\"\u0005\u0005%\u0011!\u0002\u001a/e9\u0002\u0014\u0001B;jI\u0002BCAA?\u0002\b\u0005a1m\\3gM&\u001c\u0017.\u001a8ugV\tq\u000b\u000b\u0003\u0004{\u0006\u001d\u0011!D2pK\u001a4\u0017nY5f]R\u001c\b\u0005\u000b\u0003\u0005{\u0006\u001d\u0011!C5oi\u0016\u00148-\u001a9u+\t\ti\u0002\u0005\u0003\u0002 \u0005\u0005R\"A;\n\u0007\u0005\rRO\u0001\u0004E_V\u0014G.\u001a\u0015\u0005\u000bu\f9!\u0001\u0006j]R,'oY3qi\u0002BCAB?\u0002\b\u00051A(\u001b8jiz\"r!XA\u0018\u0003g\t9\u0004C\u0003n\u000f\u0001\u0007q\u000eK\u0003\u00020u\f9\u0001\u0003\u0004\u0002\u0010\u001d\u0001\ra\u0016\u0015\u0006\u0003gi\u0018q\u0001\u0005\b\u000339\u0001\u0019AA\u000fQ\u0015\t9$`A\u0004)\u0005i\u0016A\u00038v[\u000ec\u0017m]:fgV\u0011\u0011\u0011\t\t\u0005\u0003?\t\u0019%C\u0002\u0002FU\u00141!\u00138uQ\u0011IQ0a\u0002\u0002\u00179,Xn\u00117bgN,7\u000f\t\u0015\u0005\u0015u\f9!A\u0006ok64U-\u0019;ve\u0016\u001c\b\u0006B\u0006~\u0003\u000f\tAB\\;n\r\u0016\fG/\u001e:fg\u0002BC\u0001D?\u0002\b\u0005a1/\u001a;UQJ,7\u000f[8mIR!\u0011\u0011LA.\u001b\u0005\u0001\u0001bBA/\u001b\u0001\u0007\u0011QD\u0001\u0006m\u0006dW/\u001a\u0015\u0005\u001bu\f9!\u0001\u0004nCJ<\u0017N\\\u000b\u0003\u0003K\u0002r!a\b\u0002h]\u000bi\"C\u0002\u0002jU\u0014\u0011BR;oGRLwN\\\u0019\u0002\u000f5\f'oZ5oA\u000591/^7nCJLX#\u00016)\tAi\u00181O\u0011\u0003\u0003k\nQa\r\u00182]A\n\u0001\"\u001a<bYV\fG/\u001a\u000b\u0005\u0003w\n\t\tE\u0002U\u0003{J1!a H\u0005Aa\u0015N\\3beN36iU;n[\u0006\u0014\u0018\u0010C\u0004\u0002\u0004F\u0001\r!!\"\u0002\u000f\u0011\fG/Y:fiB\"\u0011qQAL!\u0019\tI)a$\u0002\u00146\u0011\u00111\u0012\u0006\u0004\u0003\u001b[\u0015aA:rY&!\u0011\u0011SAF\u0005\u001d!\u0015\r^1tKR\u0004B!!&\u0002\u00182\u0001A\u0001DAM\u0003\u0003\u000b\t\u0011!A\u0003\u0002\u0005m%aA0%iE!\u0011QTAR!\u0011\ty\"a(\n\u0007\u0005\u0005VOA\u0004O_RD\u0017N\\4\u0011\t\u0005}\u0011QU\u0005\u0004\u0003O+(aA!os\"\"\u0011#`A:\u0003\u001d\u0001(/\u001a3jGR$B!!\b\u00020\"1\u0011\u0011\u0017\nA\u0002]\u000b\u0001BZ3biV\u0014Xm]\u0001\u000baJ,G-[2u%\u0006<HcA,\u00028\"1\u0011\u0011W\nA\u0002]CCaE?\u0002<\u0006\u0012\u0011QX\u0001\u0006g9\u0002d\u0006M\u0001\u000fe\u0006<(\u0007\u001d:fI&\u001cG/[8o)\u0011\ti\"a1\t\r\u0005\u0015G\u00031\u0001X\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\u0006!1m\u001c9z)\ri\u00161\u001a\u0005\b\u0003\u001b,\u0002\u0019AAh\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\t.a6\u000e\u0005\u0005M'bAAk\u0013\u0006)\u0001/\u0019:b[&!\u0011\u0011\\Aj\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006B\u000b~\u0003\u000f\tQ\"Z:uS6\fG/\u001a3TSj,WCAAq!\u0011\ty\"a9\n\u0007\u0005\u0015XO\u0001\u0003M_:<\u0017!B<sSR,WCAAv!\r\u0011\u0017Q^\u0005\u0004\u0003_\u001c'\u0001C'M/JLG/\u001a:)\t]i\u0018qA\u0001\ti>\u001cFO]5oOR\tq\u000e\u000b\u0003\u0019{\u0006m\u0016!D2sK\u0006$XmU;n[\u0006\u0014\u0018\u0010\u0006\u0004\u0002~\n\r!q\u0002\t\u0005\u0003?\ty0C\u0002\u0003\u0002U\u0014A!\u00168ji\"9\u00111Q\rA\u0002\t\u0015\u0001\u0007\u0002B\u0004\u0005\u0017\u0001b!!#\u0002\u0010\n%\u0001\u0003BAK\u0005\u0017!AB!\u0004\u0003\u0004\u0005\u0005\t\u0011!B\u0001\u00037\u00131a\u0018\u00136\u0011\u001d\u0011\t\"\u0007a\u0001\u0005'\t\u0001c\u001c2kK\u000e$\u0018N^3ISN$xN]=\u0011\r\u0005}!QCA\u000f\u0013\r\u00119\"\u001e\u0002\u0006\u0003J\u0014\u0018-_\u0001\fg\u00064XmU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0002~\nu\u0001B\u0002B\u00105\u0001\u0007q.\u0001\u0003qCRD\u0017a\u00037pC\u0012\u001cV/\\7bef$b!!@\u0003&\t\u001d\u0002B\u0002B\u00107\u0001\u0007q\u000eC\u0004\u0002\u0004n\u0001\rA!\u000b\u0011\t\t-\"\u0011\t\b\u0005\u0005[\u0011iD\u0004\u0003\u00030\tmb\u0002\u0002B\u0019\u0005sqAAa\r\u000389\u0019!O!\u000e\n\u0003AK!AT(\n\u00051k\u0015bAAG\u0017&!!qHAF\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0011\u0003F\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0005\u007f\tY\t\u000b\u0003\u0001{\u0006\u001d\u0011A\u0004'j]\u0016\f'o\u0015,D\u001b>$W\r\u001c\t\u0003)v\u0019r!\bB(\u0005+\u0012Y\u0006\u0005\u0003\u0002 \tE\u0013b\u0001B*k\n1\u0011I\\=SK\u001a\u0004BA\u0019B,;&\u0019!\u0011L2\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0003^\t\u001dTB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\u0005%|'B\u0001B3\u0003\u0011Q\u0017M^1\n\t\t%$q\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005\u0017\u0012A\u0001R1uCN9qDa\u0014\u0003r\t]\u0004\u0003BA\u0010\u0005gJ1A!\u001ev\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u001f\u0003\u0002:!!1\u0010B@\u001d\r\u0011(QP\u0005\u0002m&\u0019!qH;\n\t\t%$1\u0011\u0006\u0004\u0005\u007f)HC\u0002BD\u0005\u0017\u0013i\tE\u0002\u0003\n~i\u0011!\b\u0005\u0007\u0003\u001f!\u0003\u0019A,\t\u000f\u0005eA\u00051\u0001\u0002\u001eQ1!q\u0011BI\u0005'C\u0001\"a\u0004&!\u0003\u0005\ra\u0016\u0005\n\u00033)\u0003\u0013!a\u0001\u0003;\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u001a*\u001aqKa',\u0005\tu\u0005\u0003\u0002BP\u0005Ok!A!)\u000b\t\t\r&QU\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0001v\u0013\u0011\u0011IK!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t=&\u0006BA\u000f\u00057\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B[!\u0011\u00119L!0\u000e\u0005\te&\u0002\u0002B^\u0005G\nA\u0001\\1oO&\u0019!P!/\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111\u0015Bc\u0011%\u00119MKA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001b\u0004bAa4\u0003V\u0006\rVB\u0001Bi\u0015\r\u0011\u0019.^\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002Bl\u0005#\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\u001cBr!\u0011\tyBa8\n\u0007\t\u0005XOA\u0004C_>dW-\u00198\t\u0013\t\u001dG&!AA\u0002\u0005\r\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!.\u0003j\"I!qY\u0017\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\t\u000b\u0003\u0005k\u000ba!Z9vC2\u001cH\u0003\u0002Bo\u0005kD\u0011Ba21\u0003\u0003\u0005\r!a)\u0002\t\u0011\u000bG/\u0019\t\u0004\u0005\u0013\u00134#\u0002\u001a\u0003~\nm\u0003#\u0003B\u0000\u0007\u000b9\u0016Q\u0004BD\u001b\t\u0019\tAC\u0002\u0004\u0004U\fqA];oi&lW-\u0003\u0003\u0004\b\r\u0005!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!\u0011`\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0005\u000f\u001bya!\u0005\t\r\u0005=Q\u00071\u0001X\u0011\u001d\tI\"\u000ea\u0001\u0003;\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u0018\r\r\u0002CBA\u0010\u00073\u0019i\"C\u0002\u0004\u001cU\u0014aa\u00149uS>t\u0007cBA\u0010\u0007?9\u0016QD\u0005\u0004\u0007C)(A\u0002+va2,'\u0007C\u0005\u0004&Y\n\t\u00111\u0001\u0003\b\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r-\u0002\u0003\u0002B\\\u0007[IAaa\f\u0003:\n1qJ\u00196fGR\fQb]3sS\u0006d\u0017N_3ECR\fGCBA\u007f\u0007k\u0019I\u0004C\u0004\u00048a\u0002\rAa\"\u0002\t\u0011\fG/\u0019\u0005\b\u0007wA\u0004\u0019AB\u001f\u0003\r!wn\u001d\t\u0005\u0005;\u001ay$\u0003\u0003\u0004B\t}#\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0003=!Wm]3sS\u0006d\u0017N_3ECR\fG\u0003\u0002BD\u0007\u000fBqa!\u0013:\u0001\u0004\u0019Y%A\u0002eSN\u0004BA!\u0018\u0004N%!1q\nB0\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017\u0001\u0002:fC\u0012,\"a!\u0016\u0011\t\t\u001c9&X\u0005\u0004\u00073\u001a'\u0001C'M%\u0016\fG-\u001a:)\tij\u0018qA\u0001\u0005Y>\fG\rF\u0002^\u0007CBaAa\b<\u0001\u0004y\u0007\u0006B\u001e~\u0003\u000f\u0011q\u0002T5oK\u0006\u00148KV\"Xe&$XM]\n\u0006y\u0005-8\u0011\u000e\t\u0005\u0007W\u001a\t(\u0004\u0002\u0004n)\u00191qN&\u0002\u0011%tG/\u001a:oC2LAaa\u001d\u0004n\t9Aj\\4hS:<\u0017\u0001C5ogR\fgnY3\u0015\t\re41\u0010\t\u0004\u0005\u0013c\u0004BBB;}\u0001\u0007Q,\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\tip!!\t\r\t}q\b1\u0001p\u0005=a\u0015N\\3beN36IU3bI\u0016\u00148c\u0001!\u0004VQ\u00111\u0011\u0012\t\u0004\u0005\u0013\u0003\u0015!C2mCN\u001ch*Y7f\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u000b\u0004;\u000eE\u0005B\u0002B\u0010\t\u0002\u0007q\u000e\u000b\u0003\u001e{\u0006\u001d\u0001\u0006\u0002\u000f~\u0003\u000f\u0001")
public class LinearSVCModel
extends ClassificationModel<Vector, LinearSVCModel>
implements LinearSVCParams,
MLWritable,
HasTrainingSummary<LinearSVCTrainingSummary> {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final int numClasses;
    private final int numFeatures;
    private final Function1<Vector, Object> margin;
    private Option<LinearSVCTrainingSummary> trainingSummary;
    private DoubleParam threshold;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam regParam;

    public static LinearSVCModel load(String path) {
        return LinearSVCModel$.MODULE$.load(path);
    }

    public static MLReader<LinearSVCModel> read() {
        return LinearSVCModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<LinearSVCTrainingSummary> setSummary(Option<LinearSVCTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Option<LinearSVCTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<LinearSVCTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearSVCModel setThreshold(double value) {
        return (LinearSVCModel)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    @Override
    public LinearSVCTrainingSummary summary() {
        return (LinearSVCTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public LinearSVCSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ClassificationModel summaryModel = (ClassificationModel)tuple3._1();
        String rawPrediction = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)rawPrediction, (Object)predictionColName);
        ClassificationModel summaryModel2 = (ClassificationModel)tuple32._1();
        String rawPrediction2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        return new LinearSVCSummaryImpl(summaryModel2.transform(dataset), rawPrediction2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    @Override
    public double predict(Vector features) {
        if (BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features)) > BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()))) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        if (rawPrediction.apply(1) > BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()))) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public LinearSVCModel copy(ParamMap extra) {
        return (LinearSVCModel)((Model)this.copyValues(new LinearSVCModel(this.uid(), this.coefficients(), this.intercept()), extra)).setParent(this.parent());
    }

    @Override
    public long estimatedSize() {
        long size;
        block0: {
            size = this.estimateMatadataSize();
            if (this.coefficients() == null) break block0;
            size += this.coefficients().getSizeInBytes();
        }
        return size;
    }

    @Override
    public MLWriter write() {
        return new LinearSVCWriter(this);
    }

    @Override
    public String toString() {
        return "LinearSVCModel: uid=" + this.uid() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    public void createSummary(Dataset<?> dataset, double[] objectiveHistory) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ClassificationModel summaryModel = (ClassificationModel)tuple3._1();
        String rawPredictionColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)rawPredictionColName, (Object)predictionColName);
        ClassificationModel summaryModel2 = (ClassificationModel)tuple32._1();
        String rawPredictionColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        LinearSVCTrainingSummaryImpl summary = new LinearSVCTrainingSummaryImpl(summaryModel2.transform(dataset), rawPredictionColName2, predictionColName2, this.$(this.labelCol()), weightColName, objectiveHistory);
        this.setSummary((Option<LinearSVCTrainingSummary>)new Some((Object)summary));
    }

    @Override
    public void saveSummary(String path) {
        public final class Org_apache_spark_ml_classification_LinearSVCModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_classification_LinearSVCModel$$typecreator1$1(LinearSVCModel $outer) {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearSVCModel.class.getClassLoader());
        ReadWriteUtils$.MODULE$.saveObjectToLocal(path, new Tuple1((Object)this.summary().objectiveHistory()), (Function2 & Serializable)(data, dos) -> {
            ReadWriteUtils$.MODULE$.serializeDoubleArray((double[])data._1(), dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LinearSVCModel$$typecreator1$1(null)));
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        double[] objectiveHistory;
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearSVCModel.class.getClassLoader());
        public final class Org_apache_spark_ml_classification_LinearSVCModel$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_classification_LinearSVCModel$$typecreator1$2(LinearSVCModel $outer) {
            }
        }
        Tuple1 tuple1 = (Tuple1)ReadWriteUtils$.MODULE$.loadObjectFromLocal(path, (Function1 & Serializable)dis -> new Tuple1((Object)ReadWriteUtils$.MODULE$.deserializeDoubleArray((DataInputStream)dis)), ClassTag$.MODULE$.apply(Tuple1.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LinearSVCModel$$typecreator1$2(null)));
        if (tuple1 == null || (objectiveHistory = (double[])tuple1._1()) == null) {
            throw new MatchError((Object)tuple1);
        }
        double[] dArray = objectiveHistory;
        double[] objectiveHistory2 = dArray;
        this.createSummary(dataset, objectiveHistory2);
    }

    public static final /* synthetic */ double $anonfun$margin$1(LinearSVCModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this.coefficients()) + $this.intercept();
    }

    public LinearSVCModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        this.numClasses = 2;
        this.numFeatures = coefficients.size();
        this.margin = (Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)LinearSVCModel.$anonfun$margin$1(this, features));
        Statics.releaseFence();
    }

    public LinearSVCModel() {
        this("", (Vector)Vectors$.MODULE$.empty(), Double.NaN);
    }

    public static class Data
    implements Product,
    Serializable {
        private final Vector coefficients;
        private final double intercept;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Vector coefficients() {
            return this.coefficients;
        }

        public double intercept() {
            return this.intercept;
        }

        public Data copy(Vector coefficients, double intercept) {
            return new Data(coefficients, intercept);
        }

        public Vector copy$default$1() {
            return this.coefficients();
        }

        public double copy$default$2() {
            return this.intercept();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.coefficients();
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.intercept());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "coefficients";
                }
                case 1: {
                    return "intercept";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)2122698);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.intercept() != data.intercept()) return false;
            Vector vector = this.coefficients();
            Vector vector2 = data.coefficients();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(Vector coefficients, double intercept) {
            this.coefficients = coefficients;
            this.intercept = intercept;
            Product.$init$((Product)this);
        }
    }

    private static class LinearSVCReader
    extends MLReader<LinearSVCModel> {
        private final String className = LinearSVCModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearSVCModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearSVCReader.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCReader$$typecreator1$4
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.classification.LinearSVCModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCReader$$typecreator1$4(LinearSVCReader $outer) {
                }
            }
            Data data = (Data)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> LinearSVCModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCReader$$typecreator1$4(null)));
            LinearSVCModel model = new LinearSVCModel(metadata.uid(), data.coefficients(), data.intercept());
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LinearSVCWriter
    extends MLWriter {
        private final LinearSVCModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.classification.LinearSVCModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$3(LinearSVCWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data2 = new Data(this.instance.coefficients(), this.instance.intercept());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearSVCWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                LinearSVCModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LinearSVCModel$LinearSVCWriter$$typecreator1$3(null)));
        }

        public LinearSVCWriter(LinearSVCModel instance) {
            this.instance = instance;
        }
    }
}

