/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;

public final class GaussianMixtureModel$
implements MLReadable<GaussianMixtureModel>,
Serializable {
    public static final GaussianMixtureModel$ MODULE$ = new GaussianMixtureModel$();

    static {
        MLReadable.$init$(MODULE$);
    }

    public void serializeData(GaussianMixtureModel.Data data, DataOutputStream dos2) {
        ReadWriteUtils$.MODULE$.serializeDoubleArray(data.weights(), dos2);
        ReadWriteUtils$.MODULE$.serializeGenericArray(data.mus(), dos2, (Function2 & Serializable)(v, dos) -> {
            ReadWriteUtils$.MODULE$.serializeVector(v.asML(), dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(org.apache.spark.mllib.linalg.Vector.class));
        ReadWriteUtils$.MODULE$.serializeGenericArray(data.sigmas(), dos2, (Function2 & Serializable)(v, dos) -> {
            ReadWriteUtils$.MODULE$.serializeMatrix(v.asML(), dos);
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.apply(Matrix.class));
    }

    public GaussianMixtureModel.Data deserializeData(DataInputStream dis2) {
        double[] weights = ReadWriteUtils$.MODULE$.deserializeDoubleArray(dis2);
        org.apache.spark.mllib.linalg.Vector[] mus = (org.apache.spark.mllib.linalg.Vector[])ReadWriteUtils$.MODULE$.deserializeGenericArray(dis2, (Function1 & Serializable)dis -> Vectors$.MODULE$.fromML(ReadWriteUtils$.MODULE$.deserializeVector((DataInputStream)dis)), ClassTag$.MODULE$.apply(org.apache.spark.mllib.linalg.Vector.class));
        Matrix[] sigmas = (Matrix[])ReadWriteUtils$.MODULE$.deserializeGenericArray(dis2, (Function1 & Serializable)dis -> Matrices$.MODULE$.fromML(ReadWriteUtils$.MODULE$.deserializeMatrix((DataInputStream)dis)), ClassTag$.MODULE$.apply(Matrix.class));
        return new GaussianMixtureModel.Data(weights, mus, sigmas);
    }

    @Override
    public MLReader<GaussianMixtureModel> read() {
        return new GaussianMixtureModel.GaussianMixtureModelReader();
    }

    @Override
    public GaussianMixtureModel load(String path) {
        return (GaussianMixtureModel)MLReadable.load$(this, path);
    }

    public double[] computeProbabilities(Vector features, MultivariateGaussian[] dists, double[] weights) {
        int i;
        double[] probArray = (double[])Array$.MODULE$.ofDim(weights.length, (ClassTag)ClassTag$.MODULE$.Double());
        double probSum = 0.0;
        for (i = 0; i < weights.length; ++i) {
            double p;
            probArray[i] = p = Utils$.MODULE$.EPSILON() + weights[i] * dists[i].pdf(features);
            probSum += p;
        }
        i = 0;
        while (i < weights.length) {
            int n = i++;
            probArray[n] = probArray[n] / probSum;
        }
        return probArray;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GaussianMixtureModel$.class);
    }

    private GaussianMixtureModel$() {
    }
}

