/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import java.util.function.ToIntFunction;
import org.sparkproject.jetty.client.AbstractConnectionPool;
import org.sparkproject.jetty.client.Connection;
import org.sparkproject.jetty.client.ConnectionPool;
import org.sparkproject.jetty.client.Destination;
import org.sparkproject.jetty.util.ConcurrentPool;
import org.sparkproject.jetty.util.Pool;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;

@ManagedObject
public class MultiplexConnectionPool
extends AbstractConnectionPool {
    public static ToIntFunction<Connection> newMaxMultiplexer(int defaultMaxMultiplex) {
        return connection -> {
            int maxMultiplex = defaultMaxMultiplex;
            if (connection instanceof ConnectionPool.MaxMultiplexable) {
                ConnectionPool.MaxMultiplexable maxMultiplexable = (ConnectionPool.MaxMultiplexable)((Object)connection);
                maxMultiplex = maxMultiplexable.getMaxMultiplex();
            }
            return maxMultiplex;
        };
    }

    public MultiplexConnectionPool(Destination destination, int maxConnections, int initialMaxMultiplex) {
        this(destination, () -> new ConcurrentPool<Connection>(ConcurrentPool.StrategyType.FIRST, maxConnections, MultiplexConnectionPool.newMaxMultiplexer(initialMaxMultiplex)), initialMaxMultiplex);
    }

    protected MultiplexConnectionPool(Destination destination, Pool.Factory<Connection> poolFactory, int initialMaxMultiplex) {
        super(destination, poolFactory, initialMaxMultiplex);
    }

    @Override
    @ManagedAttribute(value="The initial multiplexing factor of connections")
    public int getInitialMaxMultiplex() {
        return super.getInitialMaxMultiplex();
    }

    @Override
    public void setInitialMaxMultiplex(int initialMaxMultiplex) {
        super.setInitialMaxMultiplex(initialMaxMultiplex);
    }
}

