/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.client;

import org.sparkproject.jetty.client.ProtocolHandler;
import org.sparkproject.jetty.client.Request;
import org.sparkproject.jetty.client.Response;
import org.sparkproject.jetty.client.Result;
import org.sparkproject.jetty.client.RetainingResponseListener;
import org.sparkproject.jetty.client.internal.HttpContentResponse;
import org.sparkproject.jetty.client.transport.HttpConversation;
import org.sparkproject.jetty.client.transport.HttpExchange;
import org.sparkproject.jetty.client.transport.HttpRequest;
import org.sparkproject.jetty.client.transport.ResponseListeners;
import org.sparkproject.jetty.http.HttpFields;

public class ProcessingProtocolHandler
implements ProtocolHandler {
    public static final String NAME = "processing";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.getStatus() == 102;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ProcessingListener();
    }

    protected void onProcessing(Request request, HttpFields responseHeaders) {
    }

    private class ProcessingListener
    extends RetainingResponseListener {
        private ProcessingListener() {
        }

        @Override
        public void onSuccess(Response response) {
            super.onSuccess(response);
            Request request = response.getRequest();
            HttpConversation conversation = ((HttpRequest)request).getConversation();
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange != null);
            HttpFields.Mutable responseHeaders = HttpFields.build(response.getHeaders());
            exchange.resetResponse();
            ProcessingProtocolHandler.this.onProcessing(request, responseHeaders);
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            super.onFailure(response, failure);
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            if (exchange != null) {
                ResponseListeners listeners = exchange.getResponseListeners();
                HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                listeners.emitFailureComplete(new Result(exchange.getRequest(), exchange.getRequestFailure(), contentResponse, failure));
            }
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

