/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.AllowedListeners;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.AllowedListenersBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.AllowedListenersFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayInfrastructure;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayInfrastructureBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayInfrastructureFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewaySpec;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewaySpecAddress;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewaySpecAddressBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewaySpecAddressFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayTLSConfig;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayTLSConfigBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.GatewayTLSConfigFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.Listener;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ListenerBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.ListenerFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class GatewaySpecFluent<A extends GatewaySpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<GatewaySpecAddressBuilder> addresses = new ArrayList();
    private AllowedListenersBuilder allowedListeners;
    private String defaultScope;
    private String gatewayClassName;
    private GatewayInfrastructureBuilder infrastructure;
    private ArrayList<ListenerBuilder> listeners = new ArrayList();
    private GatewayTLSConfigBuilder tls;

    public GatewaySpecFluent() {
    }

    public GatewaySpecFluent(GatewaySpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<GatewaySpecAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewaySpecAddress item : items) {
            GatewaySpecAddressBuilder builder = new GatewaySpecAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToListeners(Collection<Listener> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public A addNewAddress(String type, String value) {
        return this.addToAddresses(new GatewaySpecAddress(type, value));
    }

    public AddressesNested<A> addNewAddressLike(GatewaySpecAddress item) {
        return new AddressesNested(-1, item);
    }

    public ListenersNested<A> addNewListener() {
        return new ListenersNested(-1, null);
    }

    public ListenersNested<A> addNewListenerLike(Listener item) {
        return new ListenersNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(GatewaySpecAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewaySpecAddress item : items) {
            GatewaySpecAddressBuilder builder = new GatewaySpecAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, GatewaySpecAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewaySpecAddressBuilder builder = new GatewaySpecAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToListeners(Listener ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToListeners(int index, Listener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerBuilder builder = new ListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(index, builder);
        }
        return (A)((Object)this);
    }

    public GatewaySpecAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public List<GatewaySpecAddress> buildAddresses() {
        return this.addresses != null ? GatewaySpecFluent.build(this.addresses) : null;
    }

    public AllowedListeners buildAllowedListeners() {
        return this.allowedListeners != null ? this.allowedListeners.build() : null;
    }

    public GatewaySpecAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public Listener buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public GatewayInfrastructure buildInfrastructure() {
        return this.infrastructure != null ? this.infrastructure.build() : null;
    }

    public GatewaySpecAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public Listener buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    public Listener buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public List<Listener> buildListeners() {
        return this.listeners != null ? GatewaySpecFluent.build(this.listeners) : null;
    }

    public GatewaySpecAddress buildMatchingAddress(Predicate<GatewaySpecAddressBuilder> predicate) {
        for (GatewaySpecAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Listener buildMatchingListener(Predicate<ListenerBuilder> predicate) {
        for (ListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public GatewayTLSConfig buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    protected void copyInstance(GatewaySpec instance) {
        GatewaySpec gatewaySpec = instance = instance != null ? instance : new GatewaySpec();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withAllowedListeners(instance.getAllowedListeners());
            this.withDefaultScope(instance.getDefaultScope());
            this.withGatewayClassName(instance.getGatewayClassName());
            this.withInfrastructure(instance.getInfrastructure());
            this.withListeners(instance.getListeners());
            this.withTls(instance.getTls());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AllowedListenersNested<A> editAllowedListeners() {
        return this.withNewAllowedListenersLike(Optional.ofNullable(this.buildAllowedListeners()).orElse(null));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "listeners"));
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    public InfrastructureNested<A> editInfrastructure() {
        return this.withNewInfrastructureLike(Optional.ofNullable(this.buildInfrastructure()).orElse(null));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "listeners"));
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "listeners"));
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<GatewaySpecAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "addresses"));
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public ListenersNested<A> editMatchingListener(Predicate<ListenerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.test(this.listeners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "listeners"));
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public AllowedListenersNested<A> editOrNewAllowedListeners() {
        return this.withNewAllowedListenersLike(Optional.ofNullable(this.buildAllowedListeners()).orElse(new AllowedListenersBuilder().build()));
    }

    public AllowedListenersNested<A> editOrNewAllowedListenersLike(AllowedListeners item) {
        return this.withNewAllowedListenersLike(Optional.ofNullable(this.buildAllowedListeners()).orElse(item));
    }

    public InfrastructureNested<A> editOrNewInfrastructure() {
        return this.withNewInfrastructureLike(Optional.ofNullable(this.buildInfrastructure()).orElse(new GatewayInfrastructureBuilder().build()));
    }

    public InfrastructureNested<A> editOrNewInfrastructureLike(GatewayInfrastructure item) {
        return this.withNewInfrastructureLike(Optional.ofNullable(this.buildInfrastructure()).orElse(item));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new GatewayTLSConfigBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(GatewayTLSConfig item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewaySpecFluent that = (GatewaySpecFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals((Object)this.allowedListeners, (Object)that.allowedListeners)) {
            return false;
        }
        if (!Objects.equals(this.defaultScope, that.defaultScope)) {
            return false;
        }
        if (!Objects.equals(this.gatewayClassName, that.gatewayClassName)) {
            return false;
        }
        if (!Objects.equals((Object)this.infrastructure, (Object)that.infrastructure)) {
            return false;
        }
        if (!Objects.equals(this.listeners, that.listeners)) {
            return false;
        }
        if (!Objects.equals((Object)this.tls, (Object)that.tls)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getDefaultScope() {
        return this.defaultScope;
    }

    public String getGatewayClassName() {
        return this.gatewayClassName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasAllowedListeners() {
        return this.allowedListeners != null;
    }

    public boolean hasDefaultScope() {
        return this.defaultScope != null;
    }

    public boolean hasGatewayClassName() {
        return this.gatewayClassName != null;
    }

    public boolean hasInfrastructure() {
        return this.infrastructure != null;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public boolean hasMatchingAddress(Predicate<GatewaySpecAddressBuilder> predicate) {
        for (GatewaySpecAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingListener(Predicate<ListenerBuilder> predicate) {
        for (ListenerBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.allowedListeners, this.defaultScope, this.gatewayClassName, this.infrastructure, this.listeners, this.tls, this.additionalProperties});
    }

    public A removeAllFromAddresses(Collection<GatewaySpecAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (GatewaySpecAddress item : items) {
            GatewaySpecAddressBuilder builder = new GatewaySpecAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromListeners(Collection<Listener> items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(GatewaySpecAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (GatewaySpecAddress item : items) {
            GatewaySpecAddressBuilder builder = new GatewaySpecAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromListeners(Listener ... items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (Listener item : items) {
            ListenerBuilder builder = new ListenerBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<GatewaySpecAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<GatewaySpecAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            GatewaySpecAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromListeners(Predicate<ListenerBuilder> predicate) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        Iterator<ListenerBuilder> each = this.listeners.iterator();
        List visitables = this._visitables.get((Object)"listeners");
        while (each.hasNext()) {
            ListenerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public AddressesNested<A> setNewAddressLike(int index, GatewaySpecAddress item) {
        return new AddressesNested(index, item);
    }

    public ListenersNested<A> setNewListenerLike(int index, Listener item) {
        return new ListenersNested(index, item);
    }

    public A setToAddresses(int index, GatewaySpecAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewaySpecAddressBuilder builder = new GatewaySpecAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToListeners(int index, Listener item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerBuilder builder = new ListenerBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.allowedListeners != null) {
            sb.append("allowedListeners:");
            sb.append((Object)this.allowedListeners);
            sb.append(",");
        }
        if (this.defaultScope != null) {
            sb.append("defaultScope:");
            sb.append(this.defaultScope);
            sb.append(",");
        }
        if (this.gatewayClassName != null) {
            sb.append("gatewayClassName:");
            sb.append(this.gatewayClassName);
            sb.append(",");
        }
        if (this.infrastructure != null) {
            sb.append("infrastructure:");
            sb.append((Object)this.infrastructure);
            sb.append(",");
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            sb.append("listeners:");
            sb.append(this.listeners);
            sb.append(",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append((Object)this.tls);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddresses(List<GatewaySpecAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (GatewaySpecAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(GatewaySpecAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (GatewaySpecAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withAllowedListeners(AllowedListeners allowedListeners) {
        this._visitables.remove((Object)"allowedListeners");
        if (allowedListeners != null) {
            this.allowedListeners = new AllowedListenersBuilder(allowedListeners);
            this._visitables.get((Object)"allowedListeners").add(this.allowedListeners);
        } else {
            this.allowedListeners = null;
            this._visitables.get((Object)"allowedListeners").remove((Object)this.allowedListeners);
        }
        return (A)((Object)this);
    }

    public A withDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
        return (A)((Object)this);
    }

    public A withGatewayClassName(String gatewayClassName) {
        this.gatewayClassName = gatewayClassName;
        return (A)((Object)this);
    }

    public A withInfrastructure(GatewayInfrastructure infrastructure) {
        this._visitables.remove((Object)"infrastructure");
        if (infrastructure != null) {
            this.infrastructure = new GatewayInfrastructureBuilder(infrastructure);
            this._visitables.get((Object)"infrastructure").add(this.infrastructure);
        } else {
            this.infrastructure = null;
            this._visitables.get((Object)"infrastructure").remove((Object)this.infrastructure);
        }
        return (A)((Object)this);
    }

    public A withListeners(List<Listener> listeners) {
        if (this.listeners != null) {
            this._visitables.get((Object)"listeners").clear();
        }
        if (listeners != null) {
            this.listeners = new ArrayList();
            for (Listener item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)((Object)this);
    }

    public A withListeners(Listener ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
            this._visitables.remove((Object)"listeners");
        }
        if (listeners != null) {
            for (Listener item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)((Object)this);
    }

    public AllowedListenersNested<A> withNewAllowedListeners() {
        return new AllowedListenersNested(null);
    }

    public AllowedListenersNested<A> withNewAllowedListenersLike(AllowedListeners item) {
        return new AllowedListenersNested(item);
    }

    public InfrastructureNested<A> withNewInfrastructure() {
        return new InfrastructureNested(null);
    }

    public InfrastructureNested<A> withNewInfrastructureLike(GatewayInfrastructure item) {
        return new InfrastructureNested(item);
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(GatewayTLSConfig item) {
        return new TlsNested(item);
    }

    public A withTls(GatewayTLSConfig tls) {
        this._visitables.remove((Object)"tls");
        if (tls != null) {
            this.tls = new GatewayTLSConfigBuilder(tls);
            this._visitables.get((Object)"tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get((Object)"tls").remove((Object)this.tls);
        }
        return (A)((Object)this);
    }

    public class TlsNested<N>
    extends GatewayTLSConfigFluent<TlsNested<N>>
    implements Nested<N> {
        GatewayTLSConfigBuilder builder;

        TlsNested(GatewayTLSConfig item) {
            this.builder = new GatewayTLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)GatewaySpecFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class ListenersNested<N>
    extends ListenerFluent<ListenersNested<N>>
    implements Nested<N> {
        ListenerBuilder builder;
        int index;

        ListenersNested(int index, Listener item) {
            this.index = index;
            this.builder = new ListenerBuilder(this, item);
        }

        public N and() {
            return (N)GatewaySpecFluent.this.setToListeners(this.index, this.builder.build());
        }

        public N endListener() {
            return this.and();
        }
    }

    public class InfrastructureNested<N>
    extends GatewayInfrastructureFluent<InfrastructureNested<N>>
    implements Nested<N> {
        GatewayInfrastructureBuilder builder;

        InfrastructureNested(GatewayInfrastructure item) {
            this.builder = new GatewayInfrastructureBuilder(this, item);
        }

        public N and() {
            return (N)GatewaySpecFluent.this.withInfrastructure(this.builder.build());
        }

        public N endInfrastructure() {
            return this.and();
        }
    }

    public class AllowedListenersNested<N>
    extends AllowedListenersFluent<AllowedListenersNested<N>>
    implements Nested<N> {
        AllowedListenersBuilder builder;

        AllowedListenersNested(AllowedListeners item) {
            this.builder = new AllowedListenersBuilder(this, item);
        }

        public N and() {
            return (N)GatewaySpecFluent.this.withAllowedListeners(this.builder.build());
        }

        public N endAllowedListeners() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends GatewaySpecAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        GatewaySpecAddressBuilder builder;
        int index;

        AddressesNested(int index, GatewaySpecAddress item) {
            this.index = index;
            this.builder = new GatewaySpecAddressBuilder(this, item);
        }

        public N and() {
            return (N)GatewaySpecFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

