/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExtractValue$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateMode;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.Last;
import org.apache.spark.sql.catalyst.expressions.aggregate.PivotFirst;
import org.apache.spark.sql.catalyst.expressions.aggregate.PivotFirst$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class PivotTransformer$
implements AliasHelper,
SQLConfHelper {
    public static final PivotTransformer$ MODULE$ = new PivotTransformer$();

    static {
        AliasHelper.$init$(MODULE$);
        SQLConfHelper.$init$(MODULE$);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Project plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Aggregate plan2) {
        return AliasHelper.getAliasMap$((AliasHelper)this, plan2);
    }

    @Override
    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    @Override
    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$(this, expr, aliasMap);
    }

    @Override
    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$(this, expr, aliasMap);
    }

    @Override
    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$(this, e);
    }

    @Override
    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$(this, e);
    }

    @Override
    public final Alias mergeAndTrimAliases(Alias alias) {
        return AliasHelper.mergeAndTrimAliases$(this, alias);
    }

    @Override
    public final Alias mergeAliases(Alias alias) {
        return AliasHelper.mergeAliases$(this, alias);
    }

    public LogicalPlan apply(LogicalPlan child, Seq<Expression> pivotValues, Expression pivotColumn, Option<Seq<NamedExpression>> groupByExpressionsOpt, Seq<Expression> aggregates, Seq<Attribute> childOutput, Function2<Expression, Option<String>, Alias> newAlias) {
        Seq evalPivotValues = (Seq)pivotValues.map((Function1 & Serializable)value -> {
            boolean foldable = MODULE$.trimAliases((Expression)value).foldable();
            if (!foldable) {
                throw QueryCompilationErrors$.MODULE$.nonLiteralPivotValError((Expression)value);
            }
            if (!Cast$.MODULE$.canCast(value.dataType(), pivotColumn.dataType())) {
                throw QueryCompilationErrors$.MODULE$.pivotValDataTypeMismatchError((Expression)value, pivotColumn);
            }
            return new Cast((Expression)value, pivotColumn.dataType(), (Option<String>)new Some((Object)MODULE$.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4()).eval(package$.MODULE$.EmptyRow());
        });
        Seq groupByExpressions = (Seq)groupByExpressionsOpt.getOrElse((Function0 & Serializable)() -> {
            AttributeSet pivotColumnAndAggregatesRefs = pivotColumn.references().$plus$plus(AttributeSet$.MODULE$.apply((Iterable<Expression>)aggregates));
            return (Seq)childOutput.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)pivotColumnAndAggregatesRefs.contains(elem)));
        });
        if (aggregates.forall((Function1 & Serializable)aggregate -> BoxesRunTime.boxToBoolean((boolean)PivotFirst$.MODULE$.supportsDataType(aggregate.dataType())))) {
            NamedExpression namedExpression;
            Seq namedAggExps = (Seq)aggregates.map((Function1 & Serializable)aggregate -> (Alias)newAlias.apply(aggregate, (Object)new Some((Object)aggregate.sql())));
            Expression expression = pivotColumn;
            NamedExpression namedPivotCol = expression instanceof NamedExpression ? (namedExpression = (NamedExpression)((Object)expression)) : (NamedExpression)newAlias.apply((Object)pivotColumn, (Object)new Some((Object)"__pivot_col"));
            Seq extendedGroupingExpressions = (Seq)groupByExpressions.$colon$plus((Object)namedPivotCol);
            Aggregate firstAgg = new Aggregate((Seq<Expression>)extendedGroupingExpressions, (Seq<NamedExpression>)((Seq)extendedGroupingExpressions.$plus$plus((IterableOnce)namedAggExps)), child, Aggregate$.MODULE$.apply$default$4());
            Seq pivotAggregates = (Seq)namedAggExps.map((Function1 & Serializable)a -> (Alias)newAlias.apply((Object)new PivotFirst(namedPivotCol.toAttribute(), a.toAttribute(), (Seq<Object>)evalPivotValues, PivotFirst$.MODULE$.apply$default$4(), PivotFirst$.MODULE$.apply$default$5()).toAggregateExpression(), (Object)new Some((Object)("__pivot_" + ((Expression)((Object)a)).sql()))));
            Seq groupByExpressionsAttributes = (Seq)groupByExpressions.map((Function1 & Serializable)x$1 -> x$1.toAttribute());
            Aggregate secondAgg = new Aggregate((Seq<Expression>)groupByExpressionsAttributes, (Seq<NamedExpression>)((Seq)groupByExpressionsAttributes.$plus$plus((IterableOnce)pivotAggregates)), firstAgg, Aggregate$.MODULE$.apply$default$4());
            Seq pivotAggregatesAttributes = (Seq)pivotAggregates.map((Function1 & Serializable)x$2 -> x$2.toAttribute());
            Seq pivotOutputs = (Seq)((IterableOps)pivotValues.zipWithIndex()).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Expression value = (Expression)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return (Seq)((IterableOps)aggregates.zip((IterableOnce)pivotAggregatesAttributes)).map((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Expression aggregate = (Expression)tuple2._1();
                            Attribute pivotAtt = (Attribute)tuple2._2();
                            return (Alias)newAlias.apply((Object)ExtractValue$.MODULE$.apply(pivotAtt, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i)), MODULE$.conf().resolver()), (Object)new Some((Object)MODULE$.outputName(value, aggregate, aggregates.size() == 1)));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            return new Project((Seq<NamedExpression>)((Seq)groupByExpressionsAttributes.$plus$plus((IterableOnce)pivotOutputs)), secondAgg);
        }
        Seq pivotAggregates = (Seq)pivotValues.flatMap((Function1 & Serializable)value -> (Seq)aggregates.map((Function1 & Serializable)aggregate -> {
            Expression filteredAggregate = (Expression)((TreeNode)aggregate.transformDown(new Serializable(pivotColumn, (Expression)value){
                private static final long serialVersionUID = 0L;
                private final Expression pivotColumn$1;
                private final Expression value$2;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof First) {
                        First first = (First)A1;
                        Expression expression = first.child();
                        return (B1)new First((Expression)PivotTransformer$.MODULE$.org$apache$spark$sql$catalyst$analysis$PivotTransformer$$createIfExpression(expression, this.pivotColumn$1, this.value$2), true);
                    }
                    if (A1 instanceof Last) {
                        Last last = (Last)A1;
                        Expression expression = last.child();
                        return (B1)new Last((Expression)PivotTransformer$.MODULE$.org$apache$spark$sql$catalyst$analysis$PivotTransformer$$createIfExpression(expression, this.pivotColumn$1, this.value$2), true);
                    }
                    if (A1 instanceof ApproximatePercentile) {
                        ApproximatePercentile approximatePercentile = (ApproximatePercentile)A1;
                        If if_ = PivotTransformer$.MODULE$.org$apache$spark$sql$catalyst$analysis$PivotTransformer$$createIfExpression(approximatePercentile.first(), this.pivotColumn$1, this.value$2);
                        Expression expression = approximatePercentile.second();
                        Expression expression2 = approximatePercentile.third();
                        return (B1)approximatePercentile.withNewChildren(Nil$.MODULE$.$colon$colon((Object)expression2).$colon$colon((Object)expression).$colon$colon((Object)if_));
                    }
                    if (A1 instanceof AggregateFunction) {
                        AggregateFunction aggregateFunction = (AggregateFunction)A1;
                        return (B1)aggregateFunction.withNewChildren((Seq)aggregateFunction.children().map((Function1 & Serializable)child -> PivotTransformer$.MODULE$.org$apache$spark$sql$catalyst$analysis$PivotTransformer$$createIfExpression((Expression)child, $this.pivotColumn$1, $this.value$2)));
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    if (expression instanceof First) {
                        return true;
                    }
                    if (expression instanceof Last) {
                        return true;
                    }
                    if (expression instanceof ApproximatePercentile) {
                        return true;
                    }
                    return expression instanceof AggregateFunction;
                }
                {
                    this.pivotColumn$1 = pivotColumn$1;
                    this.value$2 = value$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.analysis.PivotTransformer$$anonfun$1 org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
                }
            })).transform(new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof AggregateExpression) {
                        AggregateExpression aggregateExpression = (AggregateExpression)A1;
                        ExprId x$1 = NamedExpression$.MODULE$.newExprId();
                        AggregateFunction x$2 = aggregateExpression.copy$default$1();
                        AggregateMode x$3 = aggregateExpression.copy$default$2();
                        boolean x$4 = aggregateExpression.copy$default$3();
                        Option<Expression> x$5 = aggregateExpression.copy$default$4();
                        return (B1)aggregateExpression.copy(x$2, x$3, x$4, x$5, x$1);
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Expression x2) {
                    Expression expression = x2;
                    return expression instanceof AggregateExpression;
                }
            });
            return (Alias)newAlias.apply((Object)filteredAggregate, (Object)new Some((Object)MODULE$.outputName((Expression)value, (Expression)aggregate, aggregates.size() == 1)));
        }));
        return new Aggregate((Seq<Expression>)groupByExpressions, (Seq<NamedExpression>)((Seq)groupByExpressions.$plus$plus((IterableOnce)pivotAggregates)), child, Aggregate$.MODULE$.apply$default$4());
    }

    private String outputName(Expression value, Expression aggregate, boolean isSingleAggregate) {
        String string;
        String stringValue;
        Expression expression = value;
        if (expression instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)((Object)expression);
            v0 = namedExpression.name();
        } else {
            Object utf8Value = new Cast(value, (DataType)StringType$.MODULE$, (Option<String>)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4()).eval(package$.MODULE$.EmptyRow());
            v0 = stringValue = (String)Option$.MODULE$.apply(utf8Value).map((Function1 & Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable)() -> "null");
        }
        if (isSingleAggregate) {
            return stringValue;
        }
        Expression expression2 = aggregate;
        if (expression2 instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)((Object)expression2);
            string = namedExpression.name();
        } else {
            string = org.apache.spark.sql.catalyst.util.package$.MODULE$.toPrettySQL(aggregate, org.apache.spark.sql.catalyst.util.package$.MODULE$.toPrettySQL$default$2());
        }
        String suffix = string;
        return stringValue + "_" + suffix;
    }

    public If org$apache$spark$sql$catalyst$analysis$PivotTransformer$$createIfExpression(Expression expression, Expression pivotColumn, Expression value) {
        return new If(new EqualNullSafe(pivotColumn, new Cast(value, pivotColumn.dataType(), (Option<String>)new Some((Object)this.conf().sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4())), expression, Literal$.MODULE$.apply(null));
    }

    private PivotTransformer$() {
    }
}

