/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TupleIntersectionBase;
import org.apache.spark.sql.catalyst.expressions.TupleIntersectionDouble$;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode;
import org.apache.spark.sql.catalyst.util.TupleSummaryMode$Sum$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(tupleSketch1, tupleSketch2, mode) - Intersects two binary representations of Datasketches\n    TupleSketch objects with double summary data type using a TupleSketch Intersection object.\n    Users can set mode to 'sum', 'min', 'max', or 'alwaysone' (defaults to 'sum'). ", examples="\n    Examples:\n      > SELECT tuple_sketch_estimate_double(_FUNC_(tuple_sketch_agg_double(col1, val1), tuple_sketch_agg_double(col2, val2))) FROM VALUES (1, 1.0D, 1, 4.0D), (2, 2.0D, 2, 5.0D), (3, 3.0D, 4, 6.0D) tab(col1, val1, col2, val2);\n       2.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001B\u0010!\u00016B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000ba\u0003A\u0011\u00010\t\u000b\u0005\u0004A\u0011\t2\t\u000b%\u0004A\u0011\t6\t\u000bM\u0004A\u0011\u000b;\t\u000f\u0005\r\u0001\u0001\"\u0015\u0002\u0006!I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011Q\u0006\u0005\n\u0003k\u0001\u0011\u0013!C\u0001\u0003oA\u0011\"!\u0014\u0001#\u0003%\t!a\u000e\t\u0013\u0005=\u0003!%A\u0005\u0002\u0005]\u0002\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0001\u0002p!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\n\u0003\u0017\u0003\u0011\u0011!C\u0001\u0003\u001bC\u0011\"a&\u0001\u0003\u0003%\t%!'\t\u0013\u0005u\u0005!!A\u0005B\u0005}u!CAbA\u0005\u0005\t\u0012AAc\r!y\u0002%!A\t\u0002\u0005\u001d\u0007B\u0002-\u001a\t\u0003\ty\u000eC\u0005\u0002bf\t\t\u0011\"\u0012\u0002d\"I\u0011Q]\r\u0002\u0002\u0013\u0005\u0015q\u001d\u0005\n\u0003_L\u0012\u0011!CA\u0003cD\u0011Ba\u0001\u001a\u0003\u0003%IA!\u0002\u0003/Q+\b\u000f\\3J]R,'o]3di&|g\u000eR8vE2,'BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qCH\u0011\t\u0004_A\u0012T\"\u0001\u0011\n\u0005E\u0002#!\u0006+va2,\u0017J\u001c;feN,7\r^5p]\n\u000b7/\u001a\t\u0003gij\u0011\u0001\u000e\u0006\u0003kY\nq!\u00193pk\ndWM\u0003\u00028q\u0005)A/\u001e9mK*\u0011\u0011\bK\u0001\rI\u0006$\u0018m]6fi\u000eDWm]\u0005\u0003wQ\u0012Q\u0002R8vE2,7+^7nCJL\bCA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$a\u0002)s_\u0012,8\r\u001e\t\u0003\u0007.s!\u0001R%\u000f\u0005\u0015CU\"\u0001$\u000b\u0005\u001dc\u0013A\u0002\u001fs_>$h(C\u0001@\u0013\tQe(A\u0004qC\u000e\\\u0017mZ3\n\u00051k%\u0001D*fe&\fG.\u001b>bE2,'B\u0001&?\u0003\u00151\u0017N]:u+\u0005\u0001\u0006CA\u0018R\u0013\t\u0011\u0006E\u0001\u0006FqB\u0014Xm]:j_:\faAZ5sgR\u0004\u0013AB:fG>tG-A\u0004tK\u000e|g\u000e\u001a\u0011\u0002\u000bQD\u0017N\u001d3\u0002\rQD\u0017N\u001d3!\u0003\u0019a\u0014N\\5u}Q!!l\u0017/^!\ty\u0003\u0001C\u0003O\u000f\u0001\u0007\u0001\u000bC\u0003U\u000f\u0001\u0007\u0001\u000bC\u0003W\u000f\u0001\u0007\u0001\u000bF\u0002[?\u0002DQA\u0014\u0005A\u0002ACQ\u0001\u0016\u0005A\u0002A\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\ti\u001bWm\u001a\u0005\u0006I&\u0001\r\u0001U\u0001\t]\u0016<h)\u001b:ti\")a-\u0003a\u0001!\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0006Q&\u0001\r\u0001U\u0001\t]\u0016<H\u000b[5sI\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003-\u0004\"\u0001\u001c9\u000f\u00055t\u0007CA#?\u0013\tyg(\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8?\u0003i\u0019'/Z1uKN+X.\\1ssN+Go\u00149fe\u0006$\u0018n\u001c8t)\t)\u0018\u0010E\u0002woJj\u0011AN\u0005\u0003qZ\u0012AcU;n[\u0006\u0014\u0018pU3u\u001fB,'/\u0019;j_:\u001c\b\"\u0002>\f\u0001\u0004Y\u0018\u0001B7pI\u0016\u0004\"\u0001`@\u000e\u0003uT!A \u0012\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u0003i(\u0001\u0005+va2,7+^7nCJLXj\u001c3f\u0003EIg\u000e^3sg\u0016\u001cGoU6fi\u000eDWm\u001d\u000b\t\u0003\u000f\ti!!\b\u0002\"A\u0019Q(!\u0003\n\u0007\u0005-aH\u0001\u0003V]&$\bbBA\b\u0019\u0001\u0007\u0011\u0011C\u0001\rg.,Go\u001952\u0005f$Xm\u001d\t\u0006{\u0005M\u0011qC\u0005\u0004\u0003+q$!B!se\u0006L\bcA\u001f\u0002\u001a%\u0019\u00111\u0004 \u0003\t\tKH/\u001a\u0005\b\u0003?a\u0001\u0019AA\t\u00031\u00198.\u001a;dQJ\u0012\u0015\u0010^3t\u0011\u001d\t\u0019\u0003\u0004a\u0001\u0003K\tA\"\u001b8uKJ\u001cXm\u0019;j_:\u0004BA^A\u0014e%\u0019\u0011\u0011\u0006\u001c\u0003\u0019%sG/\u001a:tK\u000e$\u0018n\u001c8\u0002\t\r|\u0007/\u001f\u000b\b5\u0006=\u0012\u0011GA\u001a\u0011\u001dqU\u0002%AA\u0002ACq\u0001V\u0007\u0011\u0002\u0003\u0007\u0001\u000bC\u0004W\u001bA\u0005\t\u0019\u0001)\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\b\u0016\u0004!\u0006m2FAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dc(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0013\u0002B\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013\u0001\u00027b]\u001eT!!a\u0018\u0002\t)\fg/Y\u0005\u0004c\u0006e\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA4!\ri\u0014\u0011N\u0005\u0004\u0003Wr$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA9\u0003o\u00022!PA:\u0013\r\t)H\u0010\u0002\u0004\u0003:L\b\"CA='\u0005\u0005\t\u0019AA4\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0010\t\u0007\u0003\u0003\u000b9)!\u001d\u000e\u0005\u0005\r%bAAC}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00151\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0010\u0006U\u0005cA\u001f\u0002\u0012&\u0019\u00111\u0013 \u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011P\u000b\u0002\u0002\u0003\u0007\u0011\u0011O\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002V\u0005m\u0005\"CA=-\u0005\u0005\t\u0019AA4\u0003\u0019)\u0017/^1mgR!\u0011qRAQ\u0011%\tIhFA\u0001\u0002\u0004\t\t\bK\n\u0001\u0003K\u000bY+!,\u00022\u0006M\u0016qWA]\u0003{\u000by\fE\u00020\u0003OK1!!+!\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a,\u0002\u0005cQ\u0001\u0005\t\u0011!?\u001a+fjQ0)iV\u0004H.Z*lKR\u001c\u0007.\r\u0017!iV\u0004H.Z*lKR\u001c\u0007N\r\u0017![>$W-\u000b\u0011.A%sG/\u001a:tK\u000e$8\u000f\t;x_\u0002\u0012\u0017N\\1ss\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:\u001c\be\u001c4!\t\u0006$\u0018m]6fi\u000eDWm\u001d\u0006!A\u0001\u0002C+\u001e9mKN[W\r^2iA=\u0014'.Z2ug\u0002:\u0018\u000e\u001e5!I>,(\r\\3!gVlW.\u0019:zA\u0011\fG/\u0019\u0011usB,\u0007%^:j]\u001e\u0004\u0013\r\t+va2,7k[3uG\"\u0004\u0013J\u001c;feN,7\r^5p]\u0002z'M[3di:R\u0001\u0005\t\u0011!+N,'o\u001d\u0011dC:\u00043/\u001a;![>$W\r\t;pA\u001d\u001aX/\\\u0014-A\u001dj\u0017N\\\u0014-A\u001dj\u0017\r_\u0014-A=\u0014\beJ1mo\u0006L8o\u001c8fO\u0001BC-\u001a4bk2$8\u000f\t;pA\u001d\u001aX/\\\u0014*]\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003k\u000b\u0011Q \u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!iV\u0004H.Z0tW\u0016$8\r[0fgRLW.\u0019;f?\u0012|WO\u00197fQ}3UKT\"`QQ,\b\u000f\\3`g.,Go\u00195`C\u001e<w\fZ8vE2,\u0007fY8mc1\u0002c/\u001972S1\u0002C/\u001e9mK~\u001b8.\u001a;dQ~\u000bwmZ0e_V\u0014G.\u001a\u0015d_2\u0014D\u0006\t<bYJJ\u0013&\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019-AEr\u0003\u0007\u0012\u0017!c1\u0002CG\f\u0019ES1\u0002\u0003F\r\u0017!e9\u0002D\t\f\u00113Y\u0001*d\u0006\r#*Y\u0001B3\u0007\f\u00114]A\"E\u0006\t\u001b-AYr\u0003\u0007R\u0015!i\u0006\u0014\u0007fY8mc1\u0002c/\u001972Y\u0001\u001aw\u000e\u001c\u001a-AY\fGNM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIr\u0003G\u0003\u0011!\u0003\u00159'o\\;qC\t\tY,\u0001\u0007tW\u0016$8\r[0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002B\u0006)AG\f\u001a/a\u00059B+\u001e9mK&sG/\u001a:tK\u000e$\u0018n\u001c8E_V\u0014G.\u001a\t\u0003_e\u0019R!GAe\u0003+\u0004\u0002\"a3\u0002RB\u0003\u0006KW\u0007\u0003\u0003\u001bT1!a4?\u0003\u001d\u0011XO\u001c;j[\u0016LA!a5\u0002N\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033TA!a7\u0002^\u0005\u0011\u0011n\\\u0005\u0004\u0019\u0006eGCAAc\u0003!!xn\u0015;sS:<GCAA+\u0003\u0015\t\u0007\u000f\u001d7z)\u001dQ\u0016\u0011^Av\u0003[DQA\u0014\u000fA\u0002ACQ\u0001\u0016\u000fA\u0002ACQA\u0016\u000fA\u0002A\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002t\u0006}\b#B\u001f\u0002v\u0006e\u0018bAA|}\t1q\n\u001d;j_:\u0004b!PA~!B\u0003\u0016bAA\u007f}\t1A+\u001e9mKNB\u0001B!\u0001\u001e\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0004!\u0011\t9F!\u0003\n\t\t-\u0011\u0011\f\u0002\u0007\u001f\nTWm\u0019;")
public class TupleIntersectionDouble
extends TupleIntersectionBase<DoubleSummary>
implements Serializable {
    private final Expression first;
    private final Expression second;
    private final Expression third;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(TupleIntersectionDouble x$0) {
        return TupleIntersectionDouble$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, TupleIntersectionDouble> tupled() {
        return TupleIntersectionDouble$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, TupleIntersectionDouble>>> curried() {
        return TupleIntersectionDouble$.MODULE$.curried();
    }

    @Override
    public Expression first() {
        return this.first;
    }

    @Override
    public Expression second() {
        return this.second;
    }

    @Override
    public Expression third() {
        return this.third;
    }

    @Override
    public TupleIntersectionDouble withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    @Override
    public String prettyName() {
        return "tuple_intersection_double";
    }

    @Override
    public SummarySetOperations<DoubleSummary> createSummarySetOperations(TupleSummaryMode mode) {
        return new DoubleSummarySetOperations(mode.toDoubleSummaryMode());
    }

    @Override
    public void intersectSketches(byte[] sketch1Bytes, byte[] sketch2Bytes, Intersection<DoubleSummary> intersection) {
        Sketch<DoubleSummary> tupleSketch1 = TupleSketchUtils$.MODULE$.heapifyDoubleSketch(sketch1Bytes, this.prettyName());
        Sketch<DoubleSummary> tupleSketch2 = TupleSketchUtils$.MODULE$.heapifyDoubleSketch(sketch2Bytes, this.prettyName());
        intersection.intersect(tupleSketch1);
        intersection.intersect(tupleSketch2);
    }

    public TupleIntersectionDouble copy(Expression first, Expression second, Expression third) {
        return new TupleIntersectionDouble(first, second, third);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    public Expression copy$default$3() {
        return this.third();
    }

    @Override
    public String productPrefix() {
        return "TupleIntersectionDouble";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.second();
            }
            case 2: {
                return this.third();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleIntersectionDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "first";
            }
            case 1: {
                return "second";
            }
            case 2: {
                return "third";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleIntersectionDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleIntersectionDouble tupleIntersectionDouble = (TupleIntersectionDouble)x$1;
        Expression expression = this.first();
        Expression expression2 = tupleIntersectionDouble.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = tupleIntersectionDouble.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.third();
        Expression expression6 = tupleIntersectionDouble.third();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!tupleIntersectionDouble.canEqual(this)) return false;
        return true;
    }

    public TupleIntersectionDouble(Expression first, Expression second, Expression third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public TupleIntersectionDouble(Expression first, Expression second) {
        this(first, second, Literal$.MODULE$.apply(TupleSummaryMode$Sum$.MODULE$.toString()));
    }
}

