/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.kll.KllLongsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllMergeAggBase;
import org.apache.spark.sql.catalyst.expressions.aggregate.KllMergeAggBigint$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr[, k]) - Merges binary KllLongsSketch representations and returns the merged sketch.\n      The input expression should contain binary sketch representations (e.g., from kll_sketch_agg_bigint).\n      The optional k parameter controls the size and accuracy of the merged sketch (range 8-65535).\n      If k is not specified, the merged sketch adopts the k value from the first input sketch.\n  ", examples="\n    Examples:\n      > SELECT kll_sketch_get_n_bigint(_FUNC_(sketch)) FROM (SELECT kll_sketch_agg_bigint(col) as sketch FROM VALUES (1), (2), (3) tab(col) UNION ALL SELECT kll_sketch_agg_bigint(col) as sketch FROM VALUES (4), (5), (6) tab(col)) t;\n       6\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001B\u0017/\u0001vB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tE\u0002\u0011\t\u0012)A\u0005=\"A1\r\u0001BK\u0002\u0013\u0005A\r\u0003\u0005i\u0001\tE\t\u0015!\u0003f\u0011!I\u0007A!f\u0001\n\u0003R\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B6\t\u0011=\u0004!Q3A\u0005B)D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t\u0001\u001f\u0005\u0006c\u0002!\tA\u001f\u0005\u0006{\u0002!\tE \u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\tY\u0001\u0001C)\u0003\u001bAq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002.\u0001!\t\"a\f\t\u000f\u0005U\u0002\u0001\"\u0005\u00028!9\u0011\u0011\n\u0001\u0005\u0012\u0005-\u0003bBA(\u0001\u0011E\u0011\u0011\u000b\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"a\u0019\u0001#\u0003%\t!!\u001a\t\u0013\u0005m\u0004!%A\u0005\u0002\u0005u\u0004\"CAA\u0001E\u0005I\u0011AAB\u0011%\t9\tAI\u0001\n\u0003\t\u0019\tC\u0005\u0002\n\u0002\t\t\u0011\"\u0011\u0002\f\"A\u00111\u0014\u0001\u0002\u0002\u0013\u0005!\u000eC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0001\u0002 \"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003w\u0003\u0011\u0011!C\u0001\u0003{C\u0011\"a2\u0001\u0003\u0003%\t%!3\t\u0013\u00055\u0007!!A\u0005B\u0005=w!CAz]\u0005\u0005\t\u0012AA{\r!ic&!A\t\u0002\u0005]\bBB9\"\t\u0003\u0011y\u0001C\u0005\u0003\u0012\u0005\n\t\u0011\"\u0012\u0003\u0014!I!QC\u0011\u0002\u0002\u0013\u0005%q\u0003\u0005\n\u0005C\t\u0013\u0013!C\u0001\u0003{B\u0011Ba\t\"#\u0003%\t!a!\t\u0013\t\u0015\u0012%%A\u0005\u0002\u0005\r\u0005\"\u0003B\u0014C\u0005\u0005I\u0011\u0011B\u0015\u0011%\u00119$II\u0001\n\u0003\ti\bC\u0005\u0003:\u0005\n\n\u0011\"\u0001\u0002\u0004\"I!1H\u0011\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u0005{\t\u0013\u0011!C\u0005\u0005\u007f\u0011\u0011c\u00137m\u001b\u0016\u0014x-Z!hO\nKw-\u001b8u\u0015\ty\u0003'A\u0005bO\u001e\u0014XmZ1uK*\u0011\u0011GM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00024i\u0005A1-\u0019;bYf\u001cHO\u0003\u00026m\u0005\u00191/\u001d7\u000b\u0005]B\u0014!B:qCJ\\'BA\u001d;\u0003\u0019\t\u0007/Y2iK*\t1(A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001})\u0003\u0006cA A\u00056\ta&\u0003\u0002B]\ty1\n\u001c7NKJ<W-Q4h\u0005\u0006\u001cX\r\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006\u00191\u000e\u001c7\u000b\u0005\u001dC\u0014\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018BA%E\u00059YE\u000e\u001c'p]\u001e\u001c8k[3uG\"\u0004\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002R3:\u0011!k\u0016\b\u0003'Zk\u0011\u0001\u0016\u0006\u0003+r\na\u0001\u0010:p_Rt\u0014\"A'\n\u0005ac\u0015a\u00029bG.\fw-Z\u0005\u00035n\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0017'\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003y\u0003\"a\u00181\u000e\u0003AJ!!\u0019\u0019\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0006W\u0016C\bO]\u000b\u0002KB\u00191J\u001a0\n\u0005\u001dd%AB(qi&|g.\u0001\u0004l\u000bb\u0004(\u000fI\u0001\u0017[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiV\t1\u000e\u0005\u0002LY&\u0011Q\u000e\u0014\u0002\u0004\u0013:$\u0018aF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013A\u0002\u001fj]&$h\bF\u0003tiV4x\u000f\u0005\u0002@\u0001!)A,\u0003a\u0001=\"91-\u0003I\u0001\u0002\u0004)\u0007bB5\n!\u0003\u0005\ra\u001b\u0005\b_&\u0001\n\u00111\u0001l)\t\u0019\u0018\u0010C\u0003]\u0015\u0001\u0007a\fF\u0002twrDQ\u0001X\u0006A\u0002yCQaY\u0006A\u0002y\u000bQd^5uQ:+w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0003g~Da!!\u0001\r\u0001\u0004Y\u0017!\u00078fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$HcA:\u0002\b!1\u0011\u0011B\u0007A\u0002-\fqC\\3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA:\u0002\u0010!9\u0011\u0011\u0003\bA\u0002\u0005M\u0011a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004B!UA\u000b=&\u0019\u0011qC.\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\b\u0011\t\u0005}\u0011q\u0005\b\u0005\u0003C\t\u0019\u0003\u0005\u0002T\u0019&\u0019\u0011Q\u0005'\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)\u0003T\u0001\u0010]\u0016<\b*Z1q\u0013:\u001cH/\u00198dKR\u0019!)!\r\t\r\u0005M\u0002\u00031\u0001l\u0003\u0005Y\u0017AC<sCB\u001c6.\u001a;dQR\u0019!)!\u000f\t\u000f\u0005m\u0012\u00031\u0001\u0002>\u0005)!-\u001f;fgB)1*a\u0010\u0002D%\u0019\u0011\u0011\t'\u0003\u000b\u0005\u0013(/Y=\u0011\u0007-\u000b)%C\u0002\u0002H1\u0013AAQ=uK\u0006i\u0001.Z1qS\u001aL8k[3uG\"$2AQA'\u0011\u001d\tYD\u0005a\u0001\u0003{\t1\u0002^8CsR,\u0017I\u001d:bsR!\u0011QHA*\u0011\u0019\t)f\u0005a\u0001\u0005\u000611o[3uG\"\fAaY8qsRI1/a\u0017\u0002^\u0005}\u0013\u0011\r\u0005\b9R\u0001\n\u00111\u0001_\u0011\u001d\u0019G\u0003%AA\u0002\u0015Dq!\u001b\u000b\u0011\u0002\u0003\u00071\u000eC\u0004p)A\u0005\t\u0019A6\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\r\u0016\u0004=\u0006%4FAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UD*\u0001\u0006b]:|G/\u0019;j_:LA!!\u001f\u0002p\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0010\u0016\u0004K\u0006%\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000bS3a[A5\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000bA\u0001\\1oO*\u0011\u0011qS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005E\u0015\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\u000b9\u000bE\u0002L\u0003GK1!!*M\u0005\r\te.\u001f\u0005\t\u0003S[\u0012\u0011!a\u0001W\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a,\u0011\r\u0005E\u0016qWAQ\u001b\t\t\u0019LC\u0002\u000262\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI,a-\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u007f\u000b)\rE\u0002L\u0003\u0003L1!a1M\u0005\u001d\u0011un\u001c7fC:D\u0011\"!+\u001e\u0003\u0003\u0005\r!!)\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u001b\u000bY\r\u0003\u0005\u0002*z\t\t\u00111\u0001l\u0003\u0019)\u0017/^1mgR!\u0011qXAi\u0011%\tIkHA\u0001\u0002\u0004\t\t\u000bK\n\u0001\u0003+\fY.!8\u0002b\u0006\r\u0018q]Au\u0003[\fy\u000fE\u0002`\u0003/L1!!71\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a8\u0002\u0007[Q\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(o\u0017\u0017!WvK\u0003%\f\u0011NKJ<Wm\u001d\u0011cS:\f'/\u001f\u0011LY2duN\\4t'.,Go\u00195!e\u0016\u0004(/Z:f]R\fG/[8og\u0002\ng\u000e\u001a\u0011sKR,(O\\:!i\",\u0007%\\3sO\u0016$\u0007e]6fi\u000eDgF\u0003\u0011!A\u0001\u0002\u0003\u0005\u00165fA%t\u0007/\u001e;!Kb\u0004(/Z:tS>t\u0007e\u001d5pk2$\u0007eY8oi\u0006Lg\u000e\t2j]\u0006\u0014\u0018\u0010I:lKR\u001c\u0007\u000e\t:faJ,7/\u001a8uCRLwN\\:!Q\u0015tsM\f\u0017!MJ|W\u000eI6mY~\u001b8.\u001a;dQ~\u000bwmZ0cS\u001eLg\u000e^\u0015/\u0015\u0001\u0002\u0003\u0005\t\u0011!)\",\u0007e\u001c9uS>t\u0017\r\u001c\u0011lAA\f'/Y7fi\u0016\u0014\beY8oiJ|Gn\u001d\u0011uQ\u0016\u00043/\u001b>fA\u0005tG\rI1dGV\u0014\u0018mY=!_\u001a\u0004C\u000f[3![\u0016\u0014x-\u001a3!g.,Go\u00195!QI\fgnZ3!q52T'N\u001a6S9R\u0001\u0005\t\u0011!A\u0001Je\rI6!SN\u0004cn\u001c;!gB,7-\u001b4jK\u0012d\u0003\u0005\u001e5fA5,'oZ3eAM\\W\r^2iA\u0005$w\u000e\u001d;tAQDW\rI6!m\u0006dW/\u001a\u0011ge>l\u0007\u0005\u001e5fA\u0019L'o\u001d;!S:\u0004X\u000f\u001e\u0011tW\u0016$8\r\u001b\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003K\f!q\u0001\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!W2dwl]6fi\u000eDwlZ3u?:|&-[4j]RDsLR+O\u0007~C3o[3uG\"L\u0013\u0006\t$S\u001f6\u0003\u0003fU#M\u000b\u000e#\u0006e\u001b7m?N\\W\r^2i?\u0006<wm\u00182jO&tG\u000fK2pY&\u0002\u0013m\u001d\u0011tW\u0016$8\r\u001b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B#'\u000b\u0017!QMJ\u0003\u0005^1cQ\r|G.\u000b\u0011V\u001d&{e\nI!M\u0019\u0002\u001aV\tT#D)\u0002ZG\u000e\\0tW\u0016$8\r[0bO\u001e|&-[4j]RD3m\u001c7*A\u0005\u001c\be]6fi\u000eD\u0007E\u0012*P\u001b\u00022\u0016\tT+F'\u0002BC'\u000b\u0017!QUJC\u0006\t\u00157S\u0001\"\u0018M\u0019\u0015d_2L\u0013\u0006\t;<\u0015\u0001\u0002\u0003\u0005\t\u0011!AYR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003W\f\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005E\u0018!\u0002\u001b/c9\u0002\u0014!E&mY6+'oZ3BO\u001e\u0014\u0015nZ5oiB\u0011q(I\n\u0006C\u0005e(Q\u0001\t\n\u0003w\u0014\tAX3lWNl!!!@\u000b\u0007\u0005}H*A\u0004sk:$\u0018.\\3\n\t\t\r\u0011Q \u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\t\t-\u0011QS\u0001\u0003S>L1A\u0017B\u0005)\t\t)0\u0001\u0005u_N#(/\u001b8h)\t\ti)A\u0003baBd\u0017\u0010F\u0005t\u00053\u0011YB!\b\u0003 !)A\f\na\u0001=\"91\r\nI\u0001\u0002\u0004)\u0007bB5%!\u0003\u0005\ra\u001b\u0005\b_\u0012\u0002\n\u00111\u0001l\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003,\tM\u0002\u0003B&g\u0005[\u0001ra\u0013B\u0018=\u0016\\7.C\u0002\u000321\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003B\u001bQ\u0005\u0005\t\u0019A:\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0005\u0005\u0003\u0002\u0010\n\r\u0013\u0002\u0002B#\u0003#\u0013aa\u00142kK\u000e$\b")
public class KllMergeAggBigint
extends KllMergeAggBase<KllLongsSketch>
implements Serializable {
    private final Expression child;
    private final Option<Expression> kExpr;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;

    public static int $lessinit$greater$default$4() {
        return KllMergeAggBigint$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return KllMergeAggBigint$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Expression> $lessinit$greater$default$2() {
        return KllMergeAggBigint$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple4<Expression, Option<Expression>, Object, Object>> unapply(KllMergeAggBigint x$0) {
        return KllMergeAggBigint$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return KllMergeAggBigint$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return KllMergeAggBigint$.MODULE$.apply$default$3();
    }

    public static Option<Expression> apply$default$2() {
        return KllMergeAggBigint$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, Object, Object>, KllMergeAggBigint> tupled() {
        return KllMergeAggBigint$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Object, Function1<Object, KllMergeAggBigint>>>> curried() {
        return KllMergeAggBigint$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<Expression> kExpr() {
        return this.kExpr;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public KllMergeAggBigint withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public KllMergeAggBigint withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public KllMergeAggBigint withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (newChildren.length() == 1) {
            return this.copy((Expression)newChildren.apply(0), (Option<Expression>)None$.MODULE$, this.copy$default$3(), this.copy$default$4());
        }
        return this.copy((Expression)newChildren.apply(0), (Option<Expression>)new Some(newChildren.apply(1)), this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "kll_merge_agg_bigint";
    }

    @Override
    public KllLongsSketch newHeapInstance(int k) {
        return KllLongsSketch.newHeapInstance((int)k);
    }

    @Override
    public KllLongsSketch wrapSketch(byte[] bytes) {
        return KllLongsSketch.wrap((Memory)Memory.wrap((byte[])bytes));
    }

    @Override
    public KllLongsSketch heapifySketch(byte[] bytes) {
        return KllLongsSketch.heapify((Memory)Memory.wrap((byte[])bytes));
    }

    @Override
    public byte[] toByteArray(KllLongsSketch sketch) {
        return sketch.toByteArray();
    }

    public KllMergeAggBigint copy(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new KllMergeAggBigint(child, kExpr, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Expression> copy$default$2() {
        return this.kExpr();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "KllMergeAggBigint";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.kExpr();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KllMergeAggBigint;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "kExpr";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KllMergeAggBigint)) return false;
        boolean bl = true;
        if (!bl) return false;
        KllMergeAggBigint kllMergeAggBigint = (KllMergeAggBigint)x$1;
        if (this.mutableAggBufferOffset() != kllMergeAggBigint.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != kllMergeAggBigint.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = kllMergeAggBigint.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.kExpr();
        Option<Expression> option2 = kllMergeAggBigint.kExpr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!kllMergeAggBigint.canEqual(this)) return false;
        return true;
    }

    public KllMergeAggBigint(Expression child, Option<Expression> kExpr, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.kExpr = kExpr;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public KllMergeAggBigint(Expression child) {
        this(child, (Option<Expression>)None$.MODULE$, 0, 0);
    }

    public KllMergeAggBigint(Expression child, Expression kExpr) {
        this(child, (Option<Expression>)new Some((Object)kExpr), 0, 0);
    }
}

