/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.com.google.common.collect;

import com.google.gxp.com.google.common.collect.AbstractMapBasedMultiset;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Multisets;
import com.google.gxp.com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    private static final long serialVersionUID = 0L;

    public LinkedHashMultiset() {
        super(new LinkedHashMap());
    }

    public LinkedHashMultiset(int distinctElements) {
        super(new LinkedHashMap(Maps.capacity(distinctElements)));
    }

    public LinkedHashMultiset(Iterable<? extends E> elements) {
        this(Multisets.inferDistinctElements(elements));
        Iterables.addAll(this, elements);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.setBackingMap(new LinkedHashMap());
        Serialization.populateMultiset(this, stream);
    }
}

