/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityCredential;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.DuoSecurityMultifactorAuthenticationProperties;
import org.apereo.cas.trusted.web.flow.AbstractMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.apereo.cas.web.flow.configurer.DynamicFlowModelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.model.FlowModelFlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractStateModel;
import org.springframework.webflow.engine.model.ActionStateModel;
import org.springframework.webflow.engine.model.BinderModel;
import org.springframework.webflow.engine.model.BindingModel;
import org.springframework.webflow.engine.model.EndStateModel;
import org.springframework.webflow.engine.model.EvaluateModel;
import org.springframework.webflow.engine.model.TransitionModel;
import org.springframework.webflow.engine.model.VarModel;
import org.springframework.webflow.engine.model.ViewStateModel;
import org.springframework.webflow.engine.model.builder.DefaultFlowModelHolder;
import org.springframework.webflow.engine.model.builder.FlowModelBuilder;
import org.springframework.webflow.engine.model.registry.FlowModelHolder;

public class DuoSecurityMultifactorWebflowConfigurer
extends AbstractMultifactorTrustedDeviceWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityMultifactorWebflowConfigurer.class);
    private static final String VIEW_ID_REDIRECT_TO_DUO_REGISTRATION = "redirectToDuoRegistration";

    public DuoSecurityMultifactorWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry loginFlowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, List<CasMultifactorWebflowCustomizer> mfaFlowCustomizers) {
        super(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties, Optional.empty(), mfaFlowCustomizers);
    }

    protected void doInitialize() {
        List duoConfig = this.casProperties.getAuthn().getMfa().getDuo();
        List<Pair> flowRegistryBeans = duoConfig.stream().map(duo -> {
            FlowDefinitionRegistry duoFlowRegistry = this.buildDuoFlowRegistry((DuoSecurityMultifactorAuthenticationProperties)duo);
            FlowDefinitionRegistry duoFlowRegistryInstance = (FlowDefinitionRegistry)ApplicationContextProvider.registerBeanIntoApplicationContext((ConfigurableApplicationContext)this.applicationContext, (Object)duoFlowRegistry, (String)duo.getId());
            return Pair.of((Object)duo.getId(), (Object)duoFlowRegistryInstance);
        }).collect(Collectors.toList());
        List flowRegistries = flowRegistryBeans.stream().map(Pair::getValue).collect(Collectors.toList());
        this.getMultifactorAuthenticationFlowDefinitionRegistries().addAll(flowRegistries);
        flowRegistryBeans.forEach(duo -> this.registerMultifactorProviderAuthenticationWebflow(this.getLoginFlow(), (String)duo.getKey(), (String)duo.getKey()));
        duoConfig.stream().filter(DuoSecurityMultifactorAuthenticationProperties::isTrustedDeviceEnabled).forEach(duo -> {
            String id = duo.getId();
            LOGGER.debug("Activating multifactor trusted authentication for webflow [{}]", (Object)id);
            FlowDefinitionRegistry registry = (FlowDefinitionRegistry)this.applicationContext.getBean(id, FlowDefinitionRegistry.class);
            this.registerMultifactorTrustedAuthentication(registry);
        });
    }

    private FlowDefinitionRegistry buildDuoFlowRegistry(DuoSecurityMultifactorAuthenticationProperties properties) {
        DynamicFlowModelBuilder modelBuilder = new DynamicFlowModelBuilder();
        DuoSecurityMultifactorWebflowConfigurer.createDuoFlowVariables(modelBuilder);
        DuoSecurityMultifactorWebflowConfigurer.createDuoFlowStartActions(modelBuilder);
        DuoSecurityMultifactorWebflowConfigurer.createDuoFlowStates(modelBuilder, properties);
        if (StringUtils.isBlank((CharSequence)properties.getDuoApplicationKey())) {
            this.createDuoFlowUniversalPromptActions(this.getLoginFlow());
        }
        return this.createDuoFlowDefinitionRegistry(properties, modelBuilder);
    }

    private void createDuoFlowUniversalPromptActions(Flow flow) {
        ActionState actionState = this.createActionState(flow, "duoUniversalPromptPrepareValidate", new String[]{"duoUniversalPromptValidateLoginAction"});
        TransitionableState realSubmit = this.getState(flow, "realSubmit");
        String targetSuccess = realSubmit.getTransition("success").getTargetStateId();
        this.createTransitionForState((TransitionableState)actionState, "success", targetSuccess);
        this.createTransitionForState((TransitionableState)actionState, "skip", this.getStartState(flow).getId());
        this.createTransitionForState((TransitionableState)actionState, "error", "mfaUnavailable");
        this.setStartState(flow, (TransitionableState)actionState);
    }

    private FlowDefinitionRegistry createDuoFlowDefinitionRegistry(DuoSecurityMultifactorAuthenticationProperties p, DynamicFlowModelBuilder modelBuilder) {
        DefaultFlowModelHolder holder = new DefaultFlowModelHolder((FlowModelBuilder)modelBuilder);
        FlowModelFlowBuilder flowBuilder = new FlowModelFlowBuilder((FlowModelHolder)holder);
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)this.applicationContext, this.flowBuilderServices);
        builder.addFlowBuilder((FlowBuilder)flowBuilder, p.getId());
        return builder.build();
    }

    private static void createDuoFlowStates(DynamicFlowModelBuilder modelBuilder, DuoSecurityMultifactorAuthenticationProperties properties) {
        ArrayList<AbstractStateModel> states = new ArrayList<AbstractStateModel>();
        DuoSecurityMultifactorWebflowConfigurer.createDuoInitializeLoginAction(states);
        DuoSecurityMultifactorWebflowConfigurer.createDuoDetermineUserAccountAction(states);
        DuoSecurityMultifactorWebflowConfigurer.createDuoDetermineRequestAction(states);
        DuoSecurityMultifactorWebflowConfigurer.createDuoDoNonWebAuthenticationAction(states);
        DuoSecurityMultifactorWebflowConfigurer.createDuoFinalizeAuthenticationAction(states);
        if (StringUtils.isBlank((CharSequence)properties.getDuoApplicationKey())) {
            DuoSecurityMultifactorWebflowConfigurer.createDuoUniversalPromptLoginViewState(states);
        } else {
            DuoSecurityMultifactorWebflowConfigurer.createDuoLoginViewState(states);
        }
        DuoSecurityMultifactorWebflowConfigurer.createDuoAuthenticationWebflowAction(states);
        DuoSecurityMultifactorWebflowConfigurer.createDuoRedirectToRegistrationAction(states);
        DuoSecurityMultifactorWebflowConfigurer.createDuoSuccessEndState(states);
        modelBuilder.setStates(states);
    }

    private static void createDuoUniversalPromptLoginViewState(ArrayList<AbstractStateModel> states) {
        ViewStateModel viewState = new ViewStateModel("viewLoginFormDuo");
        LinkedList<EvaluateModel> actions = new LinkedList<EvaluateModel>();
        EvaluateModel action = new EvaluateModel("duoUniversalPromptPrepareLoginAction");
        actions.add(action);
        viewState.setOnEntryActions(actions);
        viewState.setView("externalRedirect:#{flowScope.duoUniversalPromptLoginUrl}");
        states.add((AbstractStateModel)viewState);
    }

    private static void createDuoSuccessEndState(List<AbstractStateModel> states) {
        states.add((AbstractStateModel)new EndStateModel("success"));
        states.add((AbstractStateModel)new EndStateModel("mfaDenied"));
        states.add((AbstractStateModel)new EndStateModel("mfaUnavailable"));
    }

    private static void createDuoRedirectToRegistrationAction(List<AbstractStateModel> states) {
        ViewStateModel endModel = new ViewStateModel(VIEW_ID_REDIRECT_TO_DUO_REGISTRATION);
        endModel.setView("externalRedirect:#{flowScope.duoRegistrationUrl}");
        states.add((AbstractStateModel)endModel);
    }

    private static void createDuoAuthenticationWebflowAction(List<AbstractStateModel> states) {
        ActionStateModel actModel = new ActionStateModel("realSubmit");
        LinkedList<EvaluateModel> actions = new LinkedList<EvaluateModel>();
        actions.add(new EvaluateModel("duoAuthenticationWebflowAction"));
        actModel.setActions(actions);
        LinkedList<TransitionModel> trans = new LinkedList<TransitionModel>();
        TransitionModel transModel = new TransitionModel();
        transModel.setOn("success");
        transModel.setTo("success");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("error");
        transModel.setTo("initializeLoginForm");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("deny");
        transModel.setTo("mfaDenied");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("unavailable");
        transModel.setTo("mfaUnavailable");
        trans.add(transModel);
        actModel.setTransitions(trans);
        states.add((AbstractStateModel)actModel);
    }

    private static void createDuoLoginViewState(List<AbstractStateModel> states) {
        ViewStateModel viewState = new ViewStateModel("viewLoginFormDuo");
        viewState.setView("duo-security/casDuoLoginView");
        viewState.setModel("credential");
        BinderModel bm = new BinderModel();
        LinkedList<BindingModel> bindings = new LinkedList<BindingModel>();
        BindingModel bme = new BindingModel("signedDuoResponse", null, null);
        bindings.add(bme);
        bm.setBindings(bindings);
        viewState.setBinder(bm);
        LinkedList<EvaluateModel> actions = new LinkedList<EvaluateModel>();
        actions.add(new EvaluateModel("prepareDuoWebLoginFormAction"));
        viewState.setOnEntryActions(actions);
        LinkedList<TransitionModel> trans = new LinkedList<TransitionModel>();
        TransitionModel transModel = new TransitionModel();
        transModel.setOn("submit");
        transModel.setTo("realSubmit");
        transModel.setBind(Boolean.TRUE.toString());
        transModel.setValidate(Boolean.FALSE.toString());
        trans.add(transModel);
        viewState.setTransitions(trans);
        states.add((AbstractStateModel)viewState);
    }

    private static void createDuoFinalizeAuthenticationAction(List<AbstractStateModel> states) {
        ActionStateModel actModel = new ActionStateModel("finalizeAuthentication");
        LinkedList<EvaluateModel> actions = new LinkedList<EvaluateModel>();
        actions.add(new EvaluateModel("duoAuthenticationWebflowAction"));
        actModel.setActions(actions);
        LinkedList<TransitionModel> trans = new LinkedList<TransitionModel>();
        TransitionModel transModel = new TransitionModel();
        transModel.setOn("success");
        transModel.setTo("success");
        trans.add(transModel);
        actModel.setTransitions(trans);
        states.add((AbstractStateModel)actModel);
    }

    private static void createDuoDoNonWebAuthenticationAction(List<AbstractStateModel> states) {
        ActionStateModel actModel = new ActionStateModel("duoNonWebAuthentication");
        LinkedList<EvaluateModel> actions = new LinkedList<EvaluateModel>();
        actions.add(new EvaluateModel("duoNonWebAuthenticationAction"));
        actModel.setActions(actions);
        LinkedList<TransitionModel> trans = new LinkedList<TransitionModel>();
        TransitionModel transModel = new TransitionModel();
        transModel.setOn("success");
        transModel.setTo("finalizeAuthentication");
        trans.add(transModel);
        actModel.setTransitions(trans);
        states.add((AbstractStateModel)actModel);
    }

    private static void createDuoDetermineRequestAction(List<AbstractStateModel> states) {
        ActionStateModel actModel = new ActionStateModel("determineDuoRequest");
        LinkedList<EvaluateModel> actions = new LinkedList<EvaluateModel>();
        actions.add(new EvaluateModel("checkWebAuthenticationRequestAction"));
        actModel.setActions(actions);
        LinkedList<TransitionModel> trans = new LinkedList<TransitionModel>();
        TransitionModel transModel = new TransitionModel();
        transModel.setOn("yes");
        transModel.setTo("viewLoginFormDuo");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("no");
        transModel.setTo("duoNonWebAuthentication");
        trans.add(transModel);
        actModel.setTransitions(trans);
        states.add((AbstractStateModel)actModel);
    }

    private static void createDuoDetermineUserAccountAction(List<AbstractStateModel> states) {
        ActionStateModel actModel = new ActionStateModel("mfaPreAuth");
        LinkedList<EvaluateModel> actions = new LinkedList<EvaluateModel>();
        actions.add(new EvaluateModel("determineDuoUserAccountAction"));
        actModel.setActions(actions);
        LinkedList<TransitionModel> trans = new LinkedList<TransitionModel>();
        TransitionModel transModel = new TransitionModel();
        transModel.setOn("success");
        transModel.setTo("determineDuoRequest");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("enroll");
        transModel.setTo(VIEW_ID_REDIRECT_TO_DUO_REGISTRATION);
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("bypass");
        transModel.setTo("mfaCheckBypass");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("unavailable");
        transModel.setTo("mfaFailure");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("deny");
        transModel.setTo("mfaDenied");
        trans.add(transModel);
        transModel = new TransitionModel();
        transModel.setOn("error");
        transModel.setTo("initializeLoginForm");
        trans.add(transModel);
        actModel.setTransitions(trans);
        states.add((AbstractStateModel)actModel);
    }

    private static LinkedList<AbstractActionModel> createDuoInitializeLoginAction(List<AbstractStateModel> states) {
        ActionStateModel actModel = new ActionStateModel("initializeLoginForm");
        LinkedList<AbstractActionModel> actions = new LinkedList<AbstractActionModel>();
        actions.add((AbstractActionModel)new EvaluateModel("initializeLoginAction"));
        actModel.setActions(actions);
        LinkedList<TransitionModel> trans = new LinkedList<TransitionModel>();
        TransitionModel transModel = new TransitionModel();
        transModel.setOn("success");
        transModel.setTo("determineDuoUserAccount");
        trans.add(transModel);
        actModel.setTransitions(trans);
        states.add((AbstractStateModel)actModel);
        return actions;
    }

    private static void createDuoFlowStartActions(DynamicFlowModelBuilder modelBuilder) {
        ArrayList<EvaluateModel> starts = new ArrayList<EvaluateModel>(1);
        starts.add(new EvaluateModel("initialFlowSetupAction"));
        modelBuilder.setOnStartActions(starts);
    }

    private static void createDuoFlowVariables(DynamicFlowModelBuilder modelBuilder) {
        ArrayList<VarModel> vars = new ArrayList<VarModel>(1);
        vars.add(new VarModel("credential", DuoSecurityCredential.class.getName()));
        modelBuilder.setVars(vars);
    }
}

