/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config.oscache;

import org.springframework.util.StringUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.config.AbstractCacheModelParser;
import org.springmodules.cache.provider.oscache.OsCacheCachingModel;
import org.springmodules.cache.provider.oscache.OsCacheFlushingModel;
import org.w3c.dom.Element;

public final class OsCacheModelParser
extends AbstractCacheModelParser {
    public CachingModel parseCachingModel(Element element) {
        String cronExpression = element.getAttribute("cronExpression");
        String groups = element.getAttribute("groups");
        OsCacheCachingModel model = new OsCacheCachingModel(groups, cronExpression);
        String refreshPeriodAttr = element.getAttribute("refreshPeriod");
        if (StringUtils.hasText((String)refreshPeriodAttr)) {
            try {
                int refreshPeriod = Integer.parseInt(refreshPeriodAttr);
                model.setRefreshPeriod(refreshPeriod);
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        return model;
    }

    protected FlushingModel doParseFlushingModel(Element element, boolean flushBeforeMethodExecution) {
        String csvGroups = element.getAttribute("groups");
        OsCacheFlushingModel model = new OsCacheFlushingModel(csvGroups);
        model.setFlushBeforeMethodExecution(flushBeforeMethodExecution);
        return model;
    }
}

