/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class AcquireTimerJobsCmd
implements Command<List<TimerJobEntity>> {
    protected AsyncExecutor asyncExecutor;

    public AcquireTimerJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public List<TimerJobEntity> execute(CommandContext commandContext) {
        JobServiceConfiguration jobServiceConfiguration = this.asyncExecutor.getJobServiceConfiguration();
        List<String> enabledCategories = jobServiceConfiguration.getEnabledJobCategories();
        List<TimerJobEntity> timerJobs = jobServiceConfiguration.getTimerJobEntityManager().findJobsToExecute(enabledCategories, new Page(0, this.asyncExecutor.getMaxTimerJobsPerAcquisition()));
        for (TimerJobEntity job : timerJobs) {
            this.lockJob(commandContext, job, this.asyncExecutor.getTimerLockTimeInMillis(), jobServiceConfiguration);
        }
        return timerJobs;
    }

    protected void lockJob(CommandContext commandContext, TimerJobEntity job, int lockTimeInMillis, JobServiceConfiguration jobServiceConfiguration) {
        GregorianCalendar jobExpirationTime = this.calculateLockExpirationTime(lockTimeInMillis, jobServiceConfiguration);
        job.setLockOwner(this.asyncExecutor.getLockOwner());
        job.setLockExpirationTime(jobExpirationTime.getTime());
    }

    protected GregorianCalendar calculateLockExpirationTime(int lockTimeInMillis, JobServiceConfiguration jobServiceConfiguration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(jobServiceConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        return gregorianCalendar;
    }
}

