/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.List;
import java.util.Objects;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.ValueListOpenness;

public class SuggestedValues {
    private final List<Object> values;
    private final ValueListOpenness openness;

    SuggestedValues(List<Object> values) {
        this(values, ValueListOpenness.CLOSED);
    }

    SuggestedValues(List<Object> values, ValueListOpenness openness) {
        if (values == null) {
            throw new IllegalArgumentException("List of suggested values cannot be null, use empty list to indicate no values");
        }
        this.values = CollectionUtil.newReadOnlyList(values);
        this.openness = openness;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public ValueListOpenness getOpenness() {
        return this.openness;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestedValues that = (SuggestedValues)o;
        return this.values.equals(that.values) && this.openness == that.openness;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.values, this.openness});
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("Suggested values: ");
        bld.append(this.values);
        bld.append(" (").append((Object)this.openness).append(")");
        return bld.toString();
    }
}

