/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.engine.impl.util.CommandContextUtil;

public class GetEventLogEntriesCmd
implements Command<List<EventLogEntry>> {
    protected String processInstanceId;
    protected Long startLogNr;
    protected Long pageSize;

    public GetEventLogEntriesCmd() {
    }

    public GetEventLogEntriesCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public GetEventLogEntriesCmd(Long startLogNr, Long pageSize) {
        this.startLogNr = startLogNr;
        this.pageSize = pageSize;
    }

    public List<EventLogEntry> execute(CommandContext commandContext) {
        if (this.processInstanceId != null) {
            return CommandContextUtil.getEventLogEntryEntityManager(commandContext).findEventLogEntriesByProcessInstanceId(this.processInstanceId);
        }
        if (this.startLogNr != null) {
            return CommandContextUtil.getEventLogEntryEntityManager(commandContext).findEventLogEntries(this.startLogNr, this.pageSize != null ? this.pageSize : -1L);
        }
        return CommandContextUtil.getEventLogEntryEntityManager(commandContext).findAllEventLogEntries();
    }
}

