/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.profile.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonConverter
implements AttributeConverter {
    private static final Logger logger = LoggerFactory.getLogger(JsonConverter.class);
    private final Class<? extends Object> clazz;
    private TypeReference<? extends Object> typeReference;

    public JsonConverter(Class<? extends Object> clazz) {
        this.clazz = clazz;
    }

    public JsonConverter(Class<? extends Object> clazz, TypeReference<? extends Object> typeReference) {
        this(clazz);
        this.typeReference = typeReference;
    }

    public Object convert(Object attribute) {
        if (attribute != null) {
            if (this.clazz.isAssignableFrom(attribute.getClass())) {
                return attribute;
            }
            if (attribute instanceof String || attribute instanceof JsonNode) {
                String s = attribute instanceof String ? (String)attribute : JsonHelper.toJSONString(attribute);
                try {
                    if (this.typeReference != null) {
                        return JsonHelper.getMapper().readValue(s, this.typeReference);
                    }
                    return JsonHelper.getMapper().readValue(s, this.clazz);
                }
                catch (IOException e) {
                    logger.error("Cannot read value", (Throwable)e);
                }
            }
        }
        return null;
    }
}

