/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationObservationContext;
import org.springframework.security.authentication.AuthenticationObservationConvention;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

public final class ObservationAuthenticationManager
implements AuthenticationManager {
    private final ObservationRegistry registry;
    private final AuthenticationManager delegate;
    private ObservationConvention<AuthenticationObservationContext> convention = new AuthenticationObservationConvention();

    public ObservationAuthenticationManager(ObservationRegistry registry, AuthenticationManager delegate) {
        Assert.notNull((Object)registry, (String)"observationRegistry cannot be null");
        Assert.notNull((Object)delegate, (String)"authenticationManager cannot be null");
        this.registry = registry;
        this.delegate = delegate;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AuthenticationObservationContext context = new AuthenticationObservationContext();
        context.setAuthenticationRequest(authentication);
        context.setAuthenticationManagerClass(this.delegate.getClass());
        return (Authentication)Observation.createNotStarted(this.convention, () -> context, (ObservationRegistry)this.registry).observe(() -> {
            Authentication result = this.delegate.authenticate(authentication);
            context.setAuthenticationResult(result);
            return result;
        });
    }

    public void setObservationConvention(ObservationConvention<AuthenticationObservationContext> convention) {
        Assert.notNull(convention, (String)"The observation convention cannot be null");
        this.convention = convention;
    }
}

