/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public interface JpaPersistenceUnitProvider
extends DisposableBean {
    public ConfigurableApplicationContext getApplicationContext();

    public EntityManager getEntityManager();

    default public EntityManager recreateEntityManagerIfNecessary(String persistenceUnitName) {
        EntityManager currentEntityManager = this.getEntityManager();
        return (EntityManager)FunctionUtils.doIf((currentEntityManager == null && CasRuntimeHintsRegistrar.inNativeImage() ? 1 : 0) != 0, () -> {
            EntityManagerFactory entityManagerFactory = EntityManagerFactoryUtils.findEntityManagerFactory((ListableBeanFactory)this.getApplicationContext().getBeanFactory(), (String)persistenceUnitName);
            return entityManagerFactory.createEntityManager();
        }, () -> currentEntityManager).get();
    }

    default public void destroy() {
        FunctionUtils.doAndHandle(__ -> this.getEntityManager().close());
    }
}

