/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.SchemaService;
import org.apache.syncope.core.logic.SchemaLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.identityconnectors.common.CollectionUtil;

public class SchemaServiceImpl
extends AbstractService
implements SchemaService {
    protected final SchemaLogic logic;

    public SchemaServiceImpl(SchemaLogic logic) {
        this.logic = logic;
    }

    public Response create(SchemaType schemaType, SchemaTO schemaTO) {
        SchemaTO created = this.logic.create(schemaType, schemaTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public void delete(SchemaType schemaType, String key) {
        this.logic.delete(schemaType, key);
    }

    public <T extends SchemaTO> List<T> search(SchemaQuery query) {
        String keyword = query.getKeyword() == null ? null : query.getKeyword().replace('*', '%');
        return this.logic.search(query.getType(), CollectionUtil.nullAsEmpty((List)query.getAnyTypeClasses()), keyword);
    }

    public <T extends SchemaTO> T read(SchemaType schemaType, String key) {
        return (T)this.logic.read(schemaType, key);
    }

    public void update(SchemaType schemaType, SchemaTO schemaTO) {
        this.logic.update(schemaType, schemaTO);
    }

    public Attr getDropdownValues(String key, AnyTO anyTO) {
        return this.logic.getDropdownValues(key, (AttributableTO)anyTO);
    }

    public Attr getDropdownValues(String key, RealmTO realmTO) {
        return this.logic.getDropdownValues(key, (AttributableTO)realmTO);
    }
}

