/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.cmd.UnlockExclusiveJobCmd;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsyncRunnableJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteAsyncRunnableJobCmd.class);
    protected String jobId;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected boolean unlock;

    public ExecuteAsyncRunnableJobCmd(String jobId, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager, JobServiceConfiguration jobServiceConfiguration, boolean unlock) {
        this.jobId = jobId;
        this.jobEntityManager = jobEntityManager;
        this.jobServiceConfiguration = jobServiceConfiguration;
        this.unlock = unlock;
    }

    public Object execute(CommandContext commandContext) {
        if (this.jobEntityManager == null) {
            throw new FlowableIllegalArgumentException("jobEntityManager is null");
        }
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        JobInfoEntity job = (JobInfoEntity)this.jobEntityManager.findById(this.jobId);
        if (job == null) {
            LOGGER.debug("Job does not exist anymore and will not be executed. It has most likely been deleted as part of another concurrent part of the process instance.");
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            if (job instanceof JobEntity) {
                LOGGER.debug("Executing async job {}", (Object)job.getId());
            } else if (job instanceof HistoryJob) {
                LOGGER.debug("Executing history job {}", (Object)job.getId());
            }
        }
        this.jobServiceConfiguration.getJobManager().execute(job);
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, job), this.jobServiceConfiguration.getEngineName());
        }
        if (this.unlock) {
            new UnlockExclusiveJobCmd((Job)job, this.jobServiceConfiguration).execute(commandContext);
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public JobInfoEntityManager<? extends JobInfoEntity> getJobEntityManager() {
        return this.jobEntityManager;
    }

    public void setJobEntityManager(JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.jobEntityManager = jobEntityManager;
    }

    public JobServiceConfiguration getJobServiceConfiguration() {
        return this.jobServiceConfiguration;
    }

    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public boolean isUnlock() {
        return this.unlock;
    }

    public void setUnlock(boolean unlock) {
        this.unlock = unlock;
    }
}

