/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.report;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.persondir.PersonDirectoryAttributeRepositoryPlan;
import org.apereo.cas.persondir.cache.CachingPersonAttributeDaoImpl;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Endpoint(id="personDirectory", defaultAccess=Access.NONE)
public class CasPersonDirectoryEndpoint
extends BaseCasRestActuatorEndpoint {
    private final ObjectProvider<PersonAttributeDao> cachingAttributeRepository;
    private final ObjectProvider<PersonDirectoryAttributeRepositoryPlan> attributeRepositoryPlan;

    public CasPersonDirectoryEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<PersonAttributeDao> cachingAttributeRepository, ObjectProvider<PersonDirectoryAttributeRepositoryPlan> attributeRepositoryPlan) {
        super(casProperties, applicationContext);
        this.cachingAttributeRepository = cachingAttributeRepository;
        this.attributeRepositoryPlan = attributeRepositoryPlan;
    }

    @GetMapping(value={"/cache/{username}"}, produces={"application/json"})
    @Operation(summary="Display cached attributes in the attribute repository for user. If attributes are found in the cache, they are returned. Otherwise, attribute repositories will be contacted to fetch and cache person attributes again", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public PersonAttributes showCachedAttributesFor(@PathVariable(value="username") String username) {
        CachingPersonAttributeDaoImpl cachingRepository = this.getCachingPersonAttributeDao();
        return cachingRepository.getPerson(username);
    }

    @DeleteMapping(value={"/cache/{username}"}, produces={"application/json"})
    @Operation(summary="Remove cached attributes in the attribute repository for user", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to look up")})
    public void removeCachedAttributesFor(@PathVariable(value="username") String username) {
        CachingPersonAttributeDaoImpl cachingRepository = this.getCachingPersonAttributeDao();
        cachingRepository.removeUserAttributes(username);
    }

    @GetMapping(value={"/repositories"}, produces={"application/json"})
    @Operation(summary="Display available attribute repositories and their order of execution")
    public List<AttributeRepository> showAttributeRepositories() {
        return ((PersonDirectoryAttributeRepositoryPlan)this.attributeRepositoryPlan.getObject()).getAttributeRepositories().stream().map(repository -> new AttributeRepository(List.of(repository.getId()), repository.getOrder(), repository.getTags())).toList();
    }

    private CachingPersonAttributeDaoImpl getCachingPersonAttributeDao() {
        CachingPersonAttributeDaoImpl cachingRepository = (CachingPersonAttributeDaoImpl)((Object)this.cachingAttributeRepository.getObject());
        Objects.requireNonNull(cachingRepository, "Unable to locate caching attribute repository from application context");
        return cachingRepository;
    }

    public record AttributeRepository(List<String> id, int order, Map<String, Object> tags) {
    }
}

