/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.configuration.support.RegularExpressionCapable;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthTokenExchangePolicy;
import org.apereo.cas.util.RegexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DefaultRegisteredServiceOAuthTokenExchangePolicy
implements RegisteredServiceOAuthTokenExchangePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegisteredServiceOAuthTokenExchangePolicy.class);
    private static final long serialVersionUID = 1415436756392637729L;
    @RegularExpressionCapable
    private Set<String> allowedResources;
    @RegularExpressionCapable
    private Set<String> allowedAudience;
    @RegularExpressionCapable
    private Set<String> allowedTokenTypes;
    @RegularExpressionCapable
    private Set<String> allowedActorTokenTypes;
    @RegularExpressionCapable
    private Map<String, List<String>> requiredActorTokenAttributes;

    @Override
    public boolean isTokenExchangeAllowed(RegisteredService registeredService, Set<String> resources, Set<String> audience, String requestedType) {
        boolean allowedExchange;
        boolean resourceAllowed = this.allowedResources == null || this.allowedResources.stream().anyMatch(resource -> RegexUtils.findFirst((String)resource, (Collection)resources).isPresent());
        boolean audienceAllowed = this.allowedAudience == null || this.allowedAudience.stream().anyMatch(aud -> RegexUtils.findFirst((String)aud, (Collection)audience).isPresent());
        boolean tokenTypeAllowed = this.allowedTokenTypes == null || this.allowedTokenTypes.stream().anyMatch(type -> RegexUtils.find((String)type, (String)requestedType));
        boolean bl = allowedExchange = resourceAllowed && audienceAllowed && tokenTypeAllowed;
        if (!allowedExchange) {
            LOGGER.warn("Token exchange is not allowed for service [{}] for resource [{}], audience [{}] or requested token type[{}]", new Object[]{registeredService.getName(), resources, audience, requestedType});
        }
        return allowedExchange;
    }

    @Override
    public boolean canSubjectTokenActAs(Authentication subject, Authentication actor, String actorTokenType) {
        boolean actorTokenTypeAllowed = this.allowedActorTokenTypes == null || this.allowedActorTokenTypes.stream().anyMatch(type -> RegexUtils.find((String)type, (String)actorTokenType));
        HashMap availableAttributes = new HashMap(actor.getAttributes());
        availableAttributes.putAll(actor.getPrincipal().getAttributes());
        boolean actorTokenAllowed = this.requiredActorTokenAttributes == null || this.requiredActorTokenAttributes.entrySet().stream().allMatch(entry -> {
            List requiredAttributeValues = (List)entry.getValue();
            List actorAttributeValues = (List)availableAttributes.get(entry.getKey());
            return actorAttributeValues != null && requiredAttributeValues.stream().allMatch(value -> RegexUtils.findFirst((String)value, (Collection)actorAttributeValues).isPresent());
        });
        return actorTokenTypeAllowed && actorTokenAllowed;
    }

    @Generated
    public Set<String> getAllowedResources() {
        return this.allowedResources;
    }

    @Generated
    public Set<String> getAllowedAudience() {
        return this.allowedAudience;
    }

    @Generated
    public Set<String> getAllowedTokenTypes() {
        return this.allowedTokenTypes;
    }

    @Generated
    public Set<String> getAllowedActorTokenTypes() {
        return this.allowedActorTokenTypes;
    }

    @Generated
    public Map<String, List<String>> getRequiredActorTokenAttributes() {
        return this.requiredActorTokenAttributes;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setAllowedResources(Set<String> allowedResources) {
        this.allowedResources = allowedResources;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setAllowedAudience(Set<String> allowedAudience) {
        this.allowedAudience = allowedAudience;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setAllowedTokenTypes(Set<String> allowedTokenTypes) {
        this.allowedTokenTypes = allowedTokenTypes;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setAllowedActorTokenTypes(Set<String> allowedActorTokenTypes) {
        this.allowedActorTokenTypes = allowedActorTokenTypes;
        return this;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy setRequiredActorTokenAttributes(Map<String, List<String>> requiredActorTokenAttributes) {
        this.requiredActorTokenAttributes = requiredActorTokenAttributes;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRegisteredServiceOAuthTokenExchangePolicy)) {
            return false;
        }
        DefaultRegisteredServiceOAuthTokenExchangePolicy other = (DefaultRegisteredServiceOAuthTokenExchangePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$allowedResources = this.allowedResources;
        Set<String> other$allowedResources = other.allowedResources;
        if (this$allowedResources == null ? other$allowedResources != null : !((Object)this$allowedResources).equals(other$allowedResources)) {
            return false;
        }
        Set<String> this$allowedAudience = this.allowedAudience;
        Set<String> other$allowedAudience = other.allowedAudience;
        if (this$allowedAudience == null ? other$allowedAudience != null : !((Object)this$allowedAudience).equals(other$allowedAudience)) {
            return false;
        }
        Set<String> this$allowedTokenTypes = this.allowedTokenTypes;
        Set<String> other$allowedTokenTypes = other.allowedTokenTypes;
        if (this$allowedTokenTypes == null ? other$allowedTokenTypes != null : !((Object)this$allowedTokenTypes).equals(other$allowedTokenTypes)) {
            return false;
        }
        Set<String> this$allowedActorTokenTypes = this.allowedActorTokenTypes;
        Set<String> other$allowedActorTokenTypes = other.allowedActorTokenTypes;
        if (this$allowedActorTokenTypes == null ? other$allowedActorTokenTypes != null : !((Object)this$allowedActorTokenTypes).equals(other$allowedActorTokenTypes)) {
            return false;
        }
        Map<String, List<String>> this$requiredActorTokenAttributes = this.requiredActorTokenAttributes;
        Map<String, List<String>> other$requiredActorTokenAttributes = other.requiredActorTokenAttributes;
        return !(this$requiredActorTokenAttributes == null ? other$requiredActorTokenAttributes != null : !((Object)this$requiredActorTokenAttributes).equals(other$requiredActorTokenAttributes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultRegisteredServiceOAuthTokenExchangePolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $allowedResources = this.allowedResources;
        result = result * 59 + ($allowedResources == null ? 43 : ((Object)$allowedResources).hashCode());
        Set<String> $allowedAudience = this.allowedAudience;
        result = result * 59 + ($allowedAudience == null ? 43 : ((Object)$allowedAudience).hashCode());
        Set<String> $allowedTokenTypes = this.allowedTokenTypes;
        result = result * 59 + ($allowedTokenTypes == null ? 43 : ((Object)$allowedTokenTypes).hashCode());
        Set<String> $allowedActorTokenTypes = this.allowedActorTokenTypes;
        result = result * 59 + ($allowedActorTokenTypes == null ? 43 : ((Object)$allowedActorTokenTypes).hashCode());
        Map<String, List<String>> $requiredActorTokenAttributes = this.requiredActorTokenAttributes;
        result = result * 59 + ($requiredActorTokenAttributes == null ? 43 : ((Object)$requiredActorTokenAttributes).hashCode());
        return result;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy(Set<String> allowedResources, Set<String> allowedAudience, Set<String> allowedTokenTypes, Set<String> allowedActorTokenTypes, Map<String, List<String>> requiredActorTokenAttributes) {
        this.allowedResources = allowedResources;
        this.allowedAudience = allowedAudience;
        this.allowedTokenTypes = allowedTokenTypes;
        this.allowedActorTokenTypes = allowedActorTokenTypes;
        this.requiredActorTokenAttributes = requiredActorTokenAttributes;
    }

    @Generated
    public DefaultRegisteredServiceOAuthTokenExchangePolicy() {
    }

    @Generated
    public String toString() {
        return "DefaultRegisteredServiceOAuthTokenExchangePolicy(allowedResources=" + String.valueOf(this.allowedResources) + ", allowedAudience=" + String.valueOf(this.allowedAudience) + ", allowedTokenTypes=" + String.valueOf(this.allowedTokenTypes) + ", allowedActorTokenTypes=" + String.valueOf(this.allowedActorTokenTypes) + ", requiredActorTokenAttributes=" + String.valueOf(this.requiredActorTokenAttributes) + ")";
    }
}

