/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.AbstractMetadataRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd\u0001\u0002\n\u0014\u0001aAQ!\b\u0001\u0005\u0002yAQ\u0001\t\u0001\u0005B\u0005BQA\u000f\u0001\u0005\u0002mBQ!\u0018\u0001\u0005\u0002yCQa\u0019\u0001\u0005\u0002\u0011DQ!\u001b\u0001\u0005\u0002)DQa\u001c\u0001\u0005\u0002ADQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\u0002qDq!a\u0001\u0001\t\u0003\t)\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002bBA\u001a\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!a\u0016\u0001\t\u0003\tIFA\nNKR\fG-\u0019;b%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0015+\u000511/\u001a:wKJT\u0011AF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b75\t1#\u0003\u0002\u001d'\tY\u0012IY:ue\u0006\u001cG/T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#A\u0010\u0011\u0005i\u0001\u0011!B:fiV\u0003HC\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0011)f.\u001b;\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\u0011Q,7\u000f^%oM>\u0004\"a\u000b\u001b\u000e\u00031R!!\f\u0018\u0002\u0007\u0005\u0004\u0018N\u0003\u00020a\u00059!.\u001e9ji\u0016\u0014(BA\u00193\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0014aA8sO&\u0011Q\u0007\f\u0002\t)\u0016\u001cH/\u00138g_\"\u0012!a\u000e\t\u0003WaJ!!\u000f\u0017\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0011uKN$8\t\\;ti\u0016\u0014\u0018\nZ,ji\"\u0014V-];fgR4VM]:j_:\fDC\u0001\u0012=\u0011\u0015i4\u00011\u0001?\u0003\u0019\tXo\u001c:v[B\u0011qH\u0012\b\u0003\u0001\u0012\u0003\"!\u0011\u0013\u000e\u0003\tS!aQ\f\u0002\rq\u0012xn\u001c;?\u0013\t)E%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#%Q\t\u0019!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002N]\u00051\u0001/\u0019:b[NL!a\u0014'\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000f\u000b\u0003\u0004#^C\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+M\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u0001,T\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0011lW\u0011\u00025\u0006\u0011!p[\u0011\u00029\u0006)1N]1gi\u0006!B/Z:u\u00072,8\u000f^3s\u0013\u0012L5OV1mS\u0012$\"AI0\t\u000bu\"\u0001\u0019\u0001 )\u0005\u0011Q\u0005\u0006\u0002\u0003R/\nd#!W.\u0002!Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe&#GC\u0001\u0012f\u0011\u0015iT\u00011\u0001?Q\t)!\n\u000b\u0003\u0006#^CG&A-\u0002\u0011Q,7\u000f\u001e*bG.$\"AI6\t\u000bu2\u0001\u0019\u0001 )\u0005\u0019Q\u0005\u0006\u0002\u0004R/:d#!W.\u0002\u001dQ,7\u000f^%t\u0013:$XM\u001d8bYR\u0011!%\u001d\u0005\u0006{\u001d\u0001\rA\u0010\u0015\u0003\u000f)CCaB)Xi2\u0012\u0011lW\u0001\u0014i\u0016\u001cHOT8U_BL7m\u001d*fcV,7\u000f\u001e\u000b\u0003E]DQ!\u0010\u0005A\u0002yB#\u0001\u0003&)\t!\tvK\u001f\u0017\u00033n\u000bQ\u0003^3ti\u0006+Ho\u001c+pa&\u001c7I]3bi&|g\u000e\u0006\u0002#{\")Q(\u0003a\u0001}!\u0012\u0011B\u0013\u0015\u0006\u0013E;\u0016\u0011\u0001\u0017\u00033n\u000bq\u0006^3ti\u0006+Ho\\\"sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_J$2AIA\u0004\u0011\u0015i$\u00021\u0001?Q\tQ!\nK\u0003\u000b#^\u000bi\u0001\f\u0002Z7\u0006yB/Z:u\u0003V$xn\u0011:fCR,wJZ\"pY2LG-\u001b8h)>\u0004\u0018nY:\u0015\u0007\t\n\u0019\u0002C\u0003>\u0017\u0001\u0007a\b\u000b\u0002\f\u0015\"*1\"U,\u0002\u001a1\n\u0011,\u0001\u000buKN$\u0018\t\u001c7U_BL7m\u001d*fcV,7\u000f\u001e\u000b\u0004E\u0005}\u0001\"B\u001f\r\u0001\u0004q\u0004F\u0001\u0007KQ\u0015a\u0011kVA\u0013Y\tI6,\u0001\fuKN$Hk\u001c9jG&#7/\u00138SKN\u0004xN\\:f)\r\u0011\u00131\u0006\u0005\u0006{5\u0001\rA\u0010\u0015\u0003\u001b)CS!D)X\u0003ca#!W.\u0002)Q,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b)\r\u0011\u0013q\u0007\u0005\u0006{9\u0001\rA\u0010\u0015\u0003\u001d)CSAD)X\u0003{a#!W.\u0002/Q,7\u000f\u001e*fa2L7-\u0019#po:\u0014Vm\u001d9p]N,Gc\u0001\u0012\u0002D!)Qh\u0004a\u0001}!\u0012qB\u0013\u0015\u0006\u001fE;\u0016\u0011\n\u0017\u00033n\u000ba\u0005^3ti&\u001b(/\u00114uKJ\u0014%o\\6feNCW\u000f\u001e#po:\fe\u000e\u001a&pS:\u001c()Y2l)\r\u0011\u0013q\n\u0005\u0006{A\u0001\rA\u0010\u0015\u0003!)CS\u0001E)X\u0003+b#!W.\u00029Q,7\u000f^!mSZ,'I]8lKJ\u001cx+\u001b;i\u001d>$v\u000e]5dgR\u0019!%a\u0017\t\u000bu\n\u0002\u0019\u0001 )\u0005EQ\u0005&B\tR/\u0006\u0005DFA-\\\u0001")
public class MetadataRequestTest
extends AbstractMetadataRequestTest {
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdWithRequestVersion1(String quorum) {
        Assertions.assertNull((Object)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).clusterId(), (String)"v1 clusterId should be null");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testClusterIdIsValid(String quorum) {
        TestUtils.isValidClusterId((String)this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)2), this.sendMetadataRequest$default$2()).clusterId());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testControllerId(String quorum) {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$1(x$1))).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)controllerId, (int)metadataResponse.controller().id(), (String)"Controller id should match the active controller");
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testControllerId$2(x$2))).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assertions.assertNotEquals((int)controllerId, (int)controllerId2, (String)"Controller id should switch to a new broker");
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testControllerId$3(this, controllerServer2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Controller id should match the active controller after failover");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testRack(String quorum) {
        this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2()).brokers().forEach(broker -> Assertions.assertEquals((Object)new StringBuilder(5).append("rack/").append(broker.id()).toString(), (Object)broker.rack(), (String)"Rack information should match config"));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIsInternal(String quorum) {
        String internalTopic = "__consumer_offsets";
        String notInternalTopic = "notInternal";
        this.createTopic(internalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic(notInternalTopic, 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Iterable topicMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$1(internalTopic, x$3))).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsInternal$2(notInternalTopic, x$4))).get();
        Assertions.assertTrue((boolean)internalTopicMetadata.isInternal(), (String)"internalTopic should show isInternal");
        Assertions.assertFalse((boolean)notInternalTopicMetadata.isInternal(), (String)"notInternalTopic topic not should show isInternal");
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.buildCluster().internalTopics());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testNoTopicsRequest(String quorum) {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), true, (short)1).build(), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertTrue((boolean)metadataResponse.topicMetadata().isEmpty(), (String)"Response should have no topics");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoTopicCreation(String quorum) {
        String topic1 = "t1";
        String topic2 = "t2";
        String topic3 = "t3";
        String topic4 = "t4";
        String topic5 = "t5";
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertNull(response1.errors().get(topic1));
        this.checkAutoCreatedTopic(topic2, response1);
        MetadataResponse response2 = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic3, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        this.checkAutoCreatedTopic(topic3, response2);
        Assertions.assertThrows(UnsupportedVersionException.class, () -> this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)topic4, (List)Nil$.MODULE$), false), (short)3), this.sendMetadataRequest$default$2()));
        MetadataResponse response3 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic4, (List)new .colon.colon((Object)topic5, (List)Nil$.MODULE$))).asJava(), false, (short)4).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic4));
        Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response3.errors().get(topic5));
        if (!this.isKRaftTest()) {
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(topic5));
            return;
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAutoCreateTopicWithInvalidReplicationFactor(String quorum) {
        ((IterableOnceOps)this.brokers().tail()).foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)this.brokers().tail()).foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        String topic1 = "testAutoCreateTopic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)1, (int)response1.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response1.topicMetadata()).asScala().head();
        if (this.isKRaftTest()) {
            Assertions.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)topicMetadata.error());
        } else {
            Assertions.assertEquals((Object)Errors.INVALID_REPLICATION_FACTOR, (Object)topicMetadata.error());
        }
        Assertions.assertEquals((Object)topic1, (Object)topicMetadata.topic());
        Assertions.assertEquals((int)0, (int)topicMetadata.partitionMetadata().size());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testAutoCreateOfCollidingTopics(String quorum) {
        String topic1 = "testAutoCreate.Topic";
        String topic2 = "testAutoCreate_Topic";
        MetadataResponse response1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true).build(), this.sendMetadataRequest$default$2());
        Assertions.assertEquals((int)2, (int)response1.topicMetadata().size());
        scala.collection.immutable.Map responseMap = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(response1.topicMetadata()).asScala().map((Function1 & Serializable)metadata -> new Tuple2((Object)metadata.topic(), (Object)metadata.error()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2})), (Object)responseMap.keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Errors[]{Errors.LEADER_NOT_AVAILABLE, Errors.INVALID_TOPIC_EXCEPTION})), (Object)responseMap.values().toSet());
        String topicCreated = (String)((Tuple2)responseMap.head())._1();
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topicCreated, 0, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, false);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topicCreated, 0, 15000L);
        MetadataResponse response2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topicCreated, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.TopicMetadata topicMetadata1 = (MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(response2.topicMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata1.error());
        Assertions.assertEquals((Object)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata1.partitionMetadata()).asScala().map((Function1 & Serializable)x$7 -> x$7.error));
        Assertions.assertEquals((int)1, (int)topicMetadata1.partitionMetadata().size());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata1.partitionMetadata()).asScala().head();
        Assertions.assertEquals((int)0, (int)partitionMetadata.partition());
        Assertions.assertEquals((int)2, (int)partitionMetadata.replicaIds.size());
        Assertions.assertTrue((boolean)partitionMetadata.leaderId.isPresent());
        Assertions.assertTrue((Predef$.MODULE$.Integer2int((Integer)partitionMetadata.leaderId.get()) >= 0 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAllTopicsRequest(String quorum) {
        this.createTopic("t1", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        this.createTopic("t2", 3, 2, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponseV0 = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)Nil$.MODULE$, true), (short)0), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV0.errors().isEmpty(), (String)"V0 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV0.topicMetadata().size(), (String)"V0 Response should have 2 (all) topics");
        MetadataResponse metadataResponseV1 = this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), this.sendMetadataRequest$default$2());
        Assertions.assertTrue((boolean)metadataResponseV1.errors().isEmpty(), (String)"V1 Response should have no errors");
        Assertions.assertEquals((int)2, (int)metadataResponseV1.topicMetadata().size(), (String)"V1 Response should have 2 (all) topics");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicIdsInResponse(String quorum) {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopicWithAssignment(topic1, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        this.createTopicWithAssignment(topic2, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        MetadataResponse resp1 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 0, 9).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp1.topicMetadata().size());
        resp1.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
        });
        MetadataResponse resp2 = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic2, (List)Nil$.MODULE$))).asJava(), true, 10, 10).build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
        Assertions.assertEquals((int)2, (int)resp2.topicMetadata().size());
        resp2.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
            Assertions.assertNotNull((Object)topicMetadata.topicId());
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testPreferredReplica(String quorum) {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        this.createTopicWithAssignment("t1", (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        ((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})).map((Function1 & Serializable)index -> this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"t1", (List)Nil$.MODULE$)).asJava(), true).build(), (Option<SocketServer>)new Some((Object)((KafkaBroker)this.brokers().apply(BoxesRunTime.unboxToInt((Object)index))).socketServer())))).foreach((Function1 & Serializable)response -> {
            MetadataRequestTest.$anonfun$testPreferredReplica$2(replicaAssignment, response);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testReplicaDownResponse(String quorum) {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        this.createTopic(replicaDownTopic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        MetadataResponse metadataResponse = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        KafkaBroker downNode = (KafkaBroker)this.brokers().find((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$1(partitionMetadata, broker))).get();
        downNode.shutdown();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 50000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testReplicaDownResponse$2(this, replicaDownTopic, downNode)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Replica was not found down");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        MetadataResponse v0MetadataResponse = this.sendMetadataRequest(new MetadataRequest(this.requestData((List<String>)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$), true), (short)0), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v0BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))).toSeq();
        Assertions.assertTrue((boolean)v0MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v0BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertTrue((v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0, (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v0MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Errors errors = v0PartitionMetadata.error;
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assertions.assertTrue((!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0, (String)"PartitionMetadata should have an error");
        Assertions.assertTrue((v0PartitionMetadata.replicaIds.size() == replicaCount - 1 ? 1 : 0) != 0, (String)new StringBuilder(30).append("Response should have ").append(replicaCount - 1).append(" replicas").toString());
        MetadataResponse v1MetadataResponse = this.sendMetadataRequest(new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic, (List)Nil$.MODULE$)).asJava(), true).build((short)1), this.sendMetadataRequest$default$2());
        scala.collection.immutable.Seq v1BrokerIds = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.brokers()).asScala().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.id()))).toSeq();
        Assertions.assertTrue((boolean)v1MetadataResponse.errors().isEmpty(), (String)"Response should have no errors");
        Assertions.assertFalse((boolean)v1BrokerIds.contains((Object)BoxesRunTime.boxToInteger((int)downNode.config().brokerId())), (String)"The downed broker should not be in the brokers list");
        Assertions.assertEquals((int)1, (int)v1MetadataResponse.topicMetadata().size(), (String)"Response should have one topic");
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponse.TopicMetadata)CollectionConverters$.MODULE$.CollectionHasAsScala(v1MetadataResponse.topicMetadata()).asScala().head()).partitionMetadata()).asScala().head();
        Assertions.assertEquals((Object)Errors.NONE, (Object)v1PartitionMetadata.error, (String)"PartitionMetadata should have no errors");
        Assertions.assertEquals((int)replicaCount, (int)v1PartitionMetadata.replicaIds.size(), (String)new StringBuilder(30).append("Response should have ").append(replicaCount).append(" replicas").toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testIsrAfterBrokerShutDownAndJoinsBack(String quorum) {
        String topic = "isr-after-broker-shutdown";
        int replicaCount = 3;
        this.createTopic(topic, 1, replicaCount, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ((KafkaBroker)this.brokers().last()).shutdown();
        ((KafkaBroker)this.brokers().last()).awaitShutdown();
        ((KafkaBroker)this.brokers().last()).startup();
        this.checkIsr$1((Seq)this.brokers(), topic);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testAliveBrokersWithNoTopics(String quorum) {
        KafkaBroker brokerToShutdown = this.isKRaftTest() ? (KafkaBroker)this.brokers().last() : (KafkaBroker)((IterableOps)this.servers().filterNot((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$11(x$20)))).last();
        brokerToShutdown.shutdown();
        brokerToShutdown.awaitShutdown();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size() - 1);
        brokerToShutdown.startup();
        this.checkMetadata$1((Seq)this.brokers(), this.brokers().size());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$1(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$2(KafkaServer x$2) {
        return x$2.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerId$3(MetadataRequestTest $this, KafkaServer controllerServer2$1) {
        MetadataResponse metadataResponse2 = $this.sendMetadataRequest(MetadataRequest.Builder.allTopics().build((short)1), $this.sendMetadataRequest$default$2());
        return metadataResponse2.controller() != null && controllerServer2$1.dataPlaneRequestProcessor().brokerId() == metadataResponse2.controller().id();
    }

    public static final /* synthetic */ String $anonfun$testControllerId$4() {
        return "Controller id should match the active controller after failover";
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$1(String internalTopic$1, MetadataResponse.TopicMetadata x$3) {
        String string = x$3.topic();
        return !(string != null ? !string.equals(internalTopic$1) : internalTopic$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testIsInternal$2(String notInternalTopic$1, MetadataResponse.TopicMetadata x$4) {
        String string = x$4.topic();
        return !(string != null ? !string.equals(notInternalTopic$1) : notInternalTopic$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplica$2(scala.collection.immutable.Map replicaAssignment$1, MetadataResponse response) {
        Assertions.assertEquals((int)1, (int)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)response.topicMetadata().iterator().next();
        Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
        Assertions.assertEquals((Object)"t1", (Object)topicMetadata.topic());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(topicMetadata.partitionMetadata()).asScala().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.partition()))).toSet());
        topicMetadata.partitionMetadata().forEach(partitionMetadata -> {
            Seq assignment = (Seq)replicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)partitionMetadata.partition()));
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.replicaIds).asScala());
            Assertions.assertEquals((Object)assignment, (Object)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala());
            Assertions.assertEquals(Optional.of(assignment.head()), (Object)partitionMetadata.leaderId);
        });
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$1(MetadataResponse.PartitionMetadata partitionMetadata$1, KafkaBroker broker) {
        int serverId = broker.dataPlaneRequestProcessor().brokerId();
        Optional leaderId = partitionMetadata$1.leaderId;
        Buffer replicaIds = CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata$1.replicaIds).asScala();
        return leaderId.isPresent() && !BoxesRunTime.equals(leaderId.get(), (Object)BoxesRunTime.boxToInteger((int)serverId)) && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$3(KafkaBroker downNode$1, Node x$9) {
        return x$9.id() == downNode$1.dataPlaneRequestProcessor().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaDownResponse$2(MetadataRequestTest $this, String replicaDownTopic$1, KafkaBroker downNode$1) {
        MetadataResponse response = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)replicaDownTopic$1, (List)Nil$.MODULE$)).asJava(), true).build(), $this.sendMetadataRequest$default$2());
        return !CollectionConverters$.MODULE$.CollectionHasAsScala(response.brokers()).asScala().exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testReplicaDownResponse$3(downNode$1, x$9)));
    }

    public static final /* synthetic */ String $anonfun$testReplicaDownResponse$4() {
        return "Replica was not found down";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(KafkaBroker x$12) {
        BrokerState brokerState = x$12.brokerState();
        BrokerState brokerState2 = BrokerState.NOT_RUNNING;
        return brokerState == null ? brokerState2 != null : !brokerState.equals(brokerState2);
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(KafkaBroker x$13) {
        return x$13.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ boolean $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4(MetadataRequestTest $this, String topic$1, KafkaBroker broker$1, ObjectRef actualIsr$1, scala.collection.immutable.Set expectedIsr$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$1.config().brokerId())));
        Option firstPartitionMetadata = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$14 -> CollectionConverters$.MODULE$.ListHasAsScala(x$14.partitionMetadata()).asScala().headOption());
        actualIsr$1.elem = (scala.collection.immutable.Set)firstPartitionMetadata.map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set set = expectedIsr$1;
        scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)actualIsr$1.elem;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$9(KafkaBroker broker$1, scala.collection.immutable.Set expectedIsr$1, ObjectRef actualIsr$1) {
        return new StringBuilder(77).append("Topic metadata not updated correctly in broker ").append(broker$1).append("\n").append("Expected ISR: ").append(expectedIsr$1).append(" \n").append("Actual ISR : ").append((scala.collection.immutable.Set)actualIsr$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(MetadataRequestTest $this, String topic$1, scala.collection.immutable.Set expectedIsr$1, KafkaBroker broker) {
        Predef$.MODULE$.Set().empty();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            MetadataResponse $anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse = $this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic$1, (List)Nil$.MODULE$)).asJava(), false).build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker.config().brokerId())));
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.CollectionHasAsScala($anonfun$testIsrAfterBrokerShutDownAndJoinsBack$4_metadataResponse.topicMetadata()).asScala().headOption().flatMap((Function1 & Serializable)x$14 -> CollectionConverters$.MODULE$.ListHasAsScala(x$14.partitionMetadata()).asScala().headOption()).map((Function1 & Serializable)partitionMetadata -> ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionMetadata.inSyncReplicaIds).asScala().map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$7(x)))).toSet()).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
            scala.collection.immutable.Set set2 = expectedIsr$1;
            Object var10_7 = null;
            if (!(set2 != null ? !set2.equals(set) : set != null)) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(77).append("Topic metadata not updated correctly in broker ").append(broker).append("\n").append("Expected ISR: ").append(expectedIsr$1).append(" \n").append("Actual ISR : ").append(set).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void checkIsr$1(Seq brokers, String topic) {
        Seq activeBrokers = (Seq)brokers.filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$1(x$12)));
        scala.collection.immutable.Set expectedIsr = ((IterableOnceOps)activeBrokers.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$2(x$13)))).toSet();
        activeBrokers.foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testIsrAfterBrokerShutDownAndJoinsBack$3(this, topic, expectedIsr, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$1(MetadataRequestTest $this, ObjectRef response$1, int expectedBrokersCount$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.anySocketServer()));
        response$1.elem = new Some((Object)metadataResponse);
        return metadataResponse.brokers().size() == expectedBrokersCount$1;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$2(int expectedBrokersCount$1, ObjectRef response$1) {
        return new StringBuilder(33).append("Expected ").append(expectedBrokersCount$1).append(" brokers, but there are ").append(((MetadataResponse)((Option)response$1.elem).get()).brokers().size()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$4(KafkaBroker x$16) {
        BrokerState brokerState = x$16.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$6(MetadataRequestTest $this, KafkaBroker broker$2, scala.collection.immutable.Seq brokersSorted$1) {
        MetadataResponse metadataResponse = $this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)$this.brokerSocketServer(broker$2.config().brokerId())));
        scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.id()), (Ordering)Ordering.Int$.MODULE$);
        scala.collection.immutable.Seq topicMetadata = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$18 -> x$18.topic(), (Ordering)Ordering.String$.MODULE$);
        scala.collection.immutable.Seq seq = brokersSorted$1;
        if (!(seq != null ? !seq.equals(brokers) : brokers != null)) {
            Object object = CollectionConverters$.MODULE$.CollectionHasAsScala(metadataResponse.topicMetadata()).asScala().toSeq().sortBy((Function1 & Serializable)x$19 -> x$19.topic(), (Ordering)Ordering.String$.MODULE$);
            if (!(object != null ? !object.equals(topicMetadata) : topicMetadata != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testAliveBrokersWithNoTopics$10() {
        return "Topic metadata not updated correctly";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAliveBrokersWithNoTopics$5(MetadataRequestTest $this, scala.collection.immutable.Seq brokersSorted$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$6($this, broker, brokersSorted$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Topic metadata not updated correctly");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMetadata$1(Seq brokers, int expectedBrokersCount) {
        Some some;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            MetadataResponse $anonfun$testAliveBrokersWithNoTopics$1_metadataResponse = this.sendMetadataRequest((MetadataRequest)MetadataRequest.Builder.allTopics().build(), (Option<SocketServer>)new Some((Object)this.anySocketServer()));
            some = new Some((Object)$anonfun$testAliveBrokersWithNoTopics$1_metadataResponse);
            Object var10_6 = null;
            if ($anonfun$testAliveBrokersWithNoTopics$1_metadataResponse.brokers().size() == expectedBrokersCount) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(33).append("Expected ").append(expectedBrokersCount).append(" brokers, but there are ").append(((MetadataResponse)some.get()).brokers().size()).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Seq brokersSorted = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.CollectionHasAsScala(((MetadataResponse)some.get()).brokers()).asScala().toSeq().sortBy((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()), (Ordering)Ordering.Int$.MODULE$);
        ((IterableOnceOps)brokers.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$4(x$16)))).foreach((Function1 & Serializable)broker -> {
            MetadataRequestTest.$anonfun$testAliveBrokersWithNoTopics$5(this, brokersSorted, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokersWithNoTopics$11(KafkaServer x$20) {
        return x$20.kafkaController().isActive();
    }
}

