/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.WAConfigRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.rest.api.service.wa.WAConfigService;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class WAPushModalPanel
extends AbstractModalPanel<Serializable> {
    private static final long serialVersionUID = -8589310598889871801L;
    @SpringBean
    protected WAConfigRestClient waConfigRestClient;
    protected final Model<WAConfigService.PushSubject> subjectModel = new Model((Serializable)WAConfigService.PushSubject.conf);
    protected final ListModel<String> servicesModel = new ListModel();

    public WAPushModalPanel(BaseModal<Serializable> modal, List<NetworkService> instances, PageReference pageRef) {
        super(modal, pageRef);
        List addresses = instances.stream().map(NetworkService::getAddress).distinct().sorted().collect(Collectors.toList());
        this.servicesModel.setObject(addresses);
        this.add(new Component[]{new AjaxPalettePanel.Builder().setName("services").setAllowMoveAll(true).build("services", this.servicesModel, (IModel)new ListModel(addresses)).addRequiredLabel()});
        this.add(new Component[]{new AjaxDropDownChoicePanel("subject", this.getString("subject"), this.subjectModel).setChoices(List.of(WAConfigService.PushSubject.values())).setChoiceRenderer((IChoiceRenderer & Serializable)s -> this.getString(s.name(), (IModel)Model.of(), s.name())).setNullValid(false)});
    }

    public void onSubmit(AjaxRequestTarget target) {
        try {
            this.waConfigRestClient.push((WAConfigService.PushSubject)this.subjectModel.getObject(), (List)this.servicesModel.getObject());
            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While pushing to WA", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }
}

