/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRegistryEvent;
import org.flowable.eventregistry.api.EventRegistryEventConsumer;
import org.flowable.eventregistry.api.EventRegistryProcessingInfo;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.consumer.CorrelationKey;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;

public abstract class BaseEventRegistryEventConsumer
implements EventRegistryEventConsumer {
    protected AbstractEngineConfiguration engingeConfiguration;
    protected CommandExecutor commandExecutor;

    public BaseEventRegistryEventConsumer(AbstractEngineConfiguration engingeConfiguration) {
        this.engingeConfiguration = engingeConfiguration;
        this.commandExecutor = engingeConfiguration.getCommandExecutor();
    }

    public EventRegistryProcessingInfo eventReceived(EventRegistryEvent event) {
        if (event.getEventObject() != null && event.getEventObject() instanceof EventInstance) {
            return this.eventReceived((EventInstance)event.getEventObject());
        }
        if (event.getEventObject() == null) {
            throw new FlowableIllegalArgumentException("No event object was passed to the consumer");
        }
        throw new FlowableIllegalArgumentException("Unsupported event object type: " + String.valueOf(event.getEventObject().getClass()));
    }

    protected abstract EventRegistryProcessingInfo eventReceived(EventInstance var1);

    protected Collection<CorrelationKey> generateCorrelationKeys(Collection<EventPayloadInstance> correlationParameterInstances) {
        if (correlationParameterInstances.isEmpty()) {
            return Collections.emptySet();
        }
        int numberOfCorrelationParameters = correlationParameterInstances.size();
        if (numberOfCorrelationParameters == 1) {
            String correlationKey = this.generateCorrelationKey(correlationParameterInstances);
            return Collections.singleton(new CorrelationKey(correlationKey, correlationParameterInstances));
        }
        if (numberOfCorrelationParameters == 2) {
            HashSet<CorrelationKey> correlationKeys = new HashSet<CorrelationKey>();
            String allParametersCorrelationKey = this.generateCorrelationKey(correlationParameterInstances);
            correlationKeys.add(new CorrelationKey(allParametersCorrelationKey, correlationParameterInstances));
            for (EventPayloadInstance correlationParameterInstance : correlationParameterInstances) {
                Set<EventPayloadInstance> singleParameterInstance = Collections.singleton(correlationParameterInstance);
                String correlationKey = this.generateCorrelationKey(singleParameterInstance);
                correlationKeys.add(new CorrelationKey(correlationKey, singleParameterInstance));
            }
            return correlationKeys;
        }
        ArrayList<EventPayloadInstance> list = new ArrayList<EventPayloadInstance>(correlationParameterInstances);
        int correlationKeysSize = Math.toIntExact((long)Math.pow(2.0, list.size()));
        HashSet<CorrelationKey> correlationKeys = new HashSet<CorrelationKey>();
        for (int counter = 1; counter < correlationKeysSize; ++counter) {
            ArrayList<EventPayloadInstance> subset = new ArrayList<EventPayloadInstance>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                if ((counter & 1 << i) <= 0) continue;
                subset.add((EventPayloadInstance)list.get(i));
            }
            String correlationKey = this.generateCorrelationKey(subset);
            correlationKeys.add(new CorrelationKey(correlationKey, subset));
        }
        return correlationKeys;
    }

    protected String generateCorrelationKey(Collection<EventPayloadInstance> correlationParameterInstances) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (EventPayloadInstance correlationParameterInstance : correlationParameterInstances) {
            data.put(correlationParameterInstance.getDefinitionName(), correlationParameterInstance.getValue());
        }
        return this.getEventRegistry().generateKey(data);
    }

    protected EventRegistry getEventRegistry() {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = (EventRegistryEngineConfiguration)((Object)this.engingeConfiguration.getEngineConfigurations().get("cfg.eventRegistry"));
        return eventRegistryEngineConfiguration.getEventRegistry();
    }

    protected CorrelationKey getCorrelationKeyWithAllParameters(Collection<CorrelationKey> correlationKeys, EventInstance eventInstance) {
        CorrelationKey result = null;
        for (CorrelationKey correlationKey : correlationKeys) {
            if (result != null && correlationKey.getParameterInstances().size() < result.getParameterInstances().size()) continue;
            result = correlationKey;
        }
        if (result == null) {
            throw new FlowableIllegalStateException(String.format("Event definition %s does not contain correlation parameters. Cannot verify if instance already exists.", eventInstance.getEventKey()));
        }
        return result;
    }

    protected List<EventSubscription> findEventSubscriptions(String scopeType, EventInstance eventInstance, Collection<CorrelationKey> correlationKeys) {
        return (List)this.commandExecutor.execute(commandContext -> {
            EventSubscriptionQuery eventSubscriptionQuery = this.createEventSubscriptionQuery().eventType(eventInstance.getEventKey()).scopeType(scopeType);
            if (!correlationKeys.isEmpty()) {
                Set allCorrelationKeyValues = correlationKeys.stream().map(CorrelationKey::getValue).collect(Collectors.toSet());
                eventSubscriptionQuery.or().withoutConfiguration().configurations(allCorrelationKeyValues).endOr();
            } else {
                eventSubscriptionQuery.withoutConfiguration();
            }
            String eventInstanceTenantId = eventInstance.getTenantId();
            if (eventInstanceTenantId != null && !"".equals(eventInstanceTenantId)) {
                EventRegistryEngineConfiguration eventRegistryConfiguration = CommandContextUtil.getEventRegistryConfiguration();
                if (eventRegistryConfiguration.isFallbackToDefaultTenant()) {
                    String defaultTenant = eventRegistryConfiguration.getDefaultTenantProvider().getDefaultTenant(eventInstance.getTenantId(), scopeType, eventInstance.getEventKey());
                    if ("".equals(defaultTenant)) {
                        String processDefinitionKey;
                        String caseDefinitionKey;
                        EventRegistryEventConsumer eventRegistryEventConsumer;
                        eventSubscriptionQuery.or().tenantId(eventInstance.getTenantId()).withoutTenantId().endOr();
                        ArrayList<EventSubscription> cleanedEventSubscriptions = new ArrayList<EventSubscription>();
                        List eventSubscriptions = eventSubscriptionQuery.list();
                        ArrayList<String> tenantProcessDefinitionKeys = new ArrayList<String>();
                        ArrayList<String> tenantCaseDefinitionKeys = new ArrayList<String>();
                        ArrayList<EventSubscription> defaultTenantEventSubscriptions = new ArrayList<EventSubscription>();
                        for (EventSubscription eventSubscription : eventSubscriptions) {
                            if (StringUtils.isNotEmpty((CharSequence)eventSubscription.getProcessInstanceId()) || StringUtils.isNotEmpty((CharSequence)eventSubscription.getScopeId())) {
                                if (!eventInstanceTenantId.equals(eventSubscription.getTenantId())) continue;
                                cleanedEventSubscriptions.add(eventSubscription);
                                continue;
                            }
                            if (StringUtils.isEmpty((CharSequence)eventSubscription.getTenantId())) {
                                defaultTenantEventSubscriptions.add(eventSubscription);
                                continue;
                            }
                            if (StringUtils.isNotEmpty((CharSequence)eventSubscription.getScopeDefinitionKey())) {
                                tenantCaseDefinitionKeys.add(eventSubscription.getScopeDefinitionKey());
                            } else if (StringUtils.isNotEmpty((CharSequence)eventSubscription.getScopeDefinitionId())) {
                                eventRegistryEventConsumer = (EventRegistryEventConsumer)eventRegistryConfiguration.getEventRegistryEventConsumers().get("cmmnEventConsumer");
                                caseDefinitionKey = this.findDefinitionKeyById(eventRegistryEventConsumer, eventSubscription.getScopeDefinitionId());
                                if (StringUtils.isNotEmpty((CharSequence)caseDefinitionKey)) {
                                    tenantCaseDefinitionKeys.add(caseDefinitionKey);
                                }
                            } else if (StringUtils.isNotEmpty((CharSequence)eventSubscription.getProcessDefinitionId()) && StringUtils.isNotEmpty((CharSequence)(processDefinitionKey = this.findDefinitionKeyById(eventRegistryEventConsumer = (EventRegistryEventConsumer)eventRegistryConfiguration.getEventRegistryEventConsumers().get("bpmnEventConsumer"), eventSubscription.getProcessDefinitionId())))) {
                                tenantProcessDefinitionKeys.add(processDefinitionKey);
                            }
                            cleanedEventSubscriptions.add(eventSubscription);
                        }
                        if (!defaultTenantEventSubscriptions.isEmpty()) {
                            for (EventSubscription eventSubscription : defaultTenantEventSubscriptions) {
                                if (StringUtils.isNotEmpty((CharSequence)eventSubscription.getScopeDefinitionKey())) {
                                    if (tenantCaseDefinitionKeys.contains(eventSubscription.getScopeDefinitionKey())) continue;
                                    cleanedEventSubscriptions.add(eventSubscription);
                                    continue;
                                }
                                if (StringUtils.isNotEmpty((CharSequence)eventSubscription.getScopeDefinitionId())) {
                                    eventRegistryEventConsumer = (EventRegistryEventConsumer)eventRegistryConfiguration.getEventRegistryEventConsumers().get("cmmnEventConsumer");
                                    caseDefinitionKey = this.findDefinitionKeyById(eventRegistryEventConsumer, eventSubscription.getScopeDefinitionId());
                                    if (!StringUtils.isNotEmpty((CharSequence)caseDefinitionKey) || tenantCaseDefinitionKeys.contains(caseDefinitionKey)) continue;
                                    cleanedEventSubscriptions.add(eventSubscription);
                                    continue;
                                }
                                if (!StringUtils.isNotEmpty((CharSequence)eventSubscription.getProcessDefinitionId()) || !StringUtils.isNotEmpty((CharSequence)(processDefinitionKey = this.findDefinitionKeyById(eventRegistryEventConsumer = (EventRegistryEventConsumer)eventRegistryConfiguration.getEventRegistryEventConsumers().get("bpmnEventConsumer"), eventSubscription.getProcessDefinitionId()))) || tenantProcessDefinitionKeys.contains(processDefinitionKey)) continue;
                                cleanedEventSubscriptions.add(eventSubscription);
                            }
                        }
                        return cleanedEventSubscriptions;
                    }
                    eventSubscriptionQuery.tenantIds(Arrays.asList(eventInstanceTenantId, defaultTenant));
                } else {
                    eventSubscriptionQuery.tenantId(eventInstanceTenantId);
                }
            }
            return eventSubscriptionQuery.list();
        });
    }

    protected String findDefinitionKeyById(EventRegistryEventConsumer eventConsumer, String definitionId) {
        if (eventConsumer instanceof BaseEventRegistryEventConsumer) {
            BaseEventRegistryEventConsumer baseEventRegistryEventConsumer = (BaseEventRegistryEventConsumer)eventConsumer;
            return baseEventRegistryEventConsumer.findDefinitionKeyById(definitionId);
        }
        return null;
    }

    public abstract String findDefinitionKeyById(String var1);

    protected abstract EventSubscriptionQuery createEventSubscriptionQuery();
}

