/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.Optional;
import org.apache.syncope.common.lib.oidc.OIDCLoginResponse;
import org.apache.syncope.common.lib.oidc.OIDCRequest;
import org.apache.syncope.common.rest.api.service.OIDCC4UIService;
import org.apache.syncope.core.logic.OIDCC4UILogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;

public class OIDCC4UIServiceImpl
extends AbstractService
implements OIDCC4UIService {
    protected final OIDCC4UILogic logic;

    public OIDCC4UIServiceImpl(OIDCC4UILogic logic) {
        this.logic = logic;
    }

    public OIDCRequest createLoginRequest(String redirectURI, String op, boolean reauth) {
        return this.logic.createLoginRequest(redirectURI, op, reauth);
    }

    public OIDCLoginResponse login(String redirectURI, String authorizationCode, String op) {
        return this.logic.login(redirectURI, authorizationCode, op);
    }

    public OIDCRequest createLogoutRequest(String redirectURI) {
        String auth = this.messageContext.getHttpHeaders().getHeaderString("Authorization");
        String[] parts = Optional.ofNullable(auth).map(s -> s.split(" ")).orElse(null);
        if (parts == null || parts.length != 2 || !"Bearer".equals(parts[0])) {
            return null;
        }
        return this.logic.createLogoutRequest(parts[1], redirectURI);
    }

    public void backChannelLogout(String logoutToken, String redirectURI) {
        this.logic.backChannelLogout(logoutToken, redirectURI);
    }
}

