/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.monitor.ExecutableObserver;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.support.WebUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.tracing.ConditionalOnEnabledTracing;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.webflow.context.ExternalContext;

@Configuration(value="CasWebflowMonitoringConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Monitoring, CasFeatureModule.FeatureCatalog.Authentication})
@EnableAspectJAutoProxy
@Lazy(value=false)
@ConditionalOnEnabledTracing
class CasWebflowMonitoringConfiguration {
    CasWebflowMonitoringConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(name={"casWebflowMonitoringAspect"})
    public CasWebflowMonitoringAspect casWebflowMonitoringAspect(ObjectProvider<ExecutableObserver> observer) {
        return new CasWebflowMonitoringAspect(observer);
    }

    @Aspect
    record CasWebflowMonitoringAspect(ObjectProvider<ExecutableObserver> observerProvider) {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(CasWebflowMonitoringAspect.class);

        @Around(value="allComponentsThatAreWebflowExecutors()")
        public Object aroundWebflowOperations(ProceedingJoinPoint joinPoint) throws Throwable {
            String flowId = joinPoint.getArgs()[0].toString();
            ExternalContext externalContext = (ExternalContext)joinPoint.getArgs()[2];
            HttpServletRequest httpRequest = (HttpServletRequest)externalContext.getNativeRequest();
            httpRequest.setAttribute("observingWebflowId", (Object)flowId);
            String taskName = joinPoint.getSignature().getDeclaringTypeName() + "." + flowId;
            return ExecutableObserver.observe(this.observerProvider, (ProceedingJoinPoint)joinPoint, task -> task.withName(taskName).withBoundedValue("flowId", flowId).withBoundedValue("url", WebUtils.getHttpRequestFullUrl((HttpServletRequest)httpRequest)));
        }

        @Pointcut(value="within(org.springframework.webflow.executor.FlowExecutor+) && execution(* launchExecution(String,*,org.springframework.webflow.context.ExternalContext,..))")
        private void allComponentsThatAreWebflowExecutors() {
        }
    }
}

