/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.impl;

import com.netflix.spectator.atlas.impl.DataExpr;
import com.netflix.spectator.atlas.impl.Query;
import com.netflix.spectator.impl.matcher.PatternUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public final class Parser {
    private Parser() {
    }

    public static DataExpr parseDataExpr(String expr) {
        try {
            return (DataExpr)Parser.parse(expr);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("invalid data expression: " + expr, e);
        }
    }

    public static Query parseQuery(String expr) {
        try {
            return (Query)Parser.parse(expr);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("invalid query expression: " + expr, e);
        }
    }

    private static Object parse(String expr) {
        int depth = 0;
        ArrayList<String> vs = null;
        String[] parts = expr.split(",");
        ArrayDeque<Object> stack = new ArrayDeque<Object>(parts.length);
        block58: for (String p : parts) {
            String token = Parser.unescape(p.trim());
            if (token.isEmpty()) continue;
            if (!(vs == null || depth <= 0 && ")".equals(token))) {
                if ("(".equals(token)) {
                    ++depth;
                } else if (")".equals(token)) {
                    --depth;
                }
                vs.add(token);
                continue;
            }
            switch (token) {
                case "(": {
                    vs = new ArrayList<String>();
                    continue block58;
                }
                case ")": {
                    if (vs == null) {
                        throw new IllegalArgumentException("unmatched closing paren: " + expr);
                    }
                    stack.push(vs);
                    vs = null;
                    depth = 0;
                    continue block58;
                }
                case ":true": {
                    stack.push(Query.TRUE);
                    continue block58;
                }
                case ":false": {
                    stack.push(Query.FALSE);
                    continue block58;
                }
                case ":and": {
                    Query q2 = (Query)stack.pop();
                    Query q1 = (Query)stack.pop();
                    stack.push(q1.and(q2));
                    continue block58;
                }
                case ":or": {
                    Query q2 = (Query)stack.pop();
                    Query q1 = (Query)stack.pop();
                    stack.push(q1.or(q2));
                    continue block58;
                }
                case ":not": {
                    Query q = (Query)stack.pop();
                    stack.push(q.not());
                    continue block58;
                }
                case ":has": {
                    String k = (String)stack.pop();
                    stack.push(new Query.Has(k));
                    continue block58;
                }
                case ":eq": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.Equal(k, v));
                    continue block58;
                }
                case ":in": {
                    List tmp = (List)stack.pop();
                    String k = (String)stack.pop();
                    Parser.pushIn(stack, k, tmp);
                    continue block58;
                }
                case ":lt": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.LessThan(k, v));
                    continue block58;
                }
                case ":le": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.LessThanEqual(k, v));
                    continue block58;
                }
                case ":gt": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.GreaterThan(k, v));
                    continue block58;
                }
                case ":ge": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    stack.push(new Query.GreaterThanEqual(k, v));
                    continue block58;
                }
                case ":re": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    Parser.pushRegex(stack, new Query.Regex(k, v));
                    continue block58;
                }
                case ":reic": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    Parser.pushRegex(stack, new Query.Regex(k, v, true, ":reic"));
                    continue block58;
                }
                case ":contains": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    Parser.pushRegex(stack, new Query.Regex(k, ".*" + PatternUtils.escape((String)v)));
                    continue block58;
                }
                case ":starts": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    Parser.pushRegex(stack, new Query.Regex(k, PatternUtils.escape((String)v)));
                    continue block58;
                }
                case ":ends": {
                    String v = (String)stack.pop();
                    String k = (String)stack.pop();
                    Parser.pushRegex(stack, new Query.Regex(k, ".*" + PatternUtils.escape((String)v) + "$"));
                    continue block58;
                }
                case ":all": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.All(q));
                    continue block58;
                }
                case ":sum": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Sum(q));
                    continue block58;
                }
                case ":min": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Min(q));
                    continue block58;
                }
                case ":max": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Max(q));
                    continue block58;
                }
                case ":count": {
                    Query q = (Query)stack.pop();
                    stack.push(new DataExpr.Count(q));
                    continue block58;
                }
                case ":by": {
                    List tmp = (List)stack.pop();
                    DataExpr.AggregateFunction af = (DataExpr.AggregateFunction)stack.pop();
                    stack.push(new DataExpr.GroupBy(af, new LinkedHashSet<String>(tmp)));
                    continue block58;
                }
                case ":rollup-drop": {
                    List tmp = (List)stack.pop();
                    DataExpr.AggregateFunction af = (DataExpr.AggregateFunction)stack.pop();
                    stack.push(new DataExpr.DropRollup(af, tmp));
                    continue block58;
                }
                case ":rollup-keep": {
                    List tmp = (List)stack.pop();
                    DataExpr.AggregateFunction af = (DataExpr.AggregateFunction)stack.pop();
                    stack.push(new DataExpr.KeepRollup(af, tmp));
                    continue block58;
                }
                default: {
                    if (token.startsWith(":")) {
                        throw new IllegalArgumentException("unknown word '" + token + "'");
                    }
                    stack.push(token);
                }
            }
        }
        Object obj = stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalArgumentException("too many items remaining on stack: " + stack);
        }
        return obj;
    }

    private static void pushRegex(Deque<Object> stack, Query.Regex q) {
        if (q.alwaysMatches()) {
            stack.push(new Query.Has(q.key()));
        } else {
            stack.push(q);
        }
    }

    private static void pushIn(Deque<Object> stack, String k, List<String> values) {
        if (values.size() == 1) {
            stack.push(new Query.Equal(k, values.get(0)));
        } else {
            stack.push(new Query.In(k, new HashSet<String>(values)));
        }
    }

    static boolean isSpecial(int codePoint) {
        return codePoint == 44 || Character.isWhitespace(codePoint);
    }

    static void zeroPad(String str, StringBuilder builder) {
        int width = 4;
        int n = 4 - str.length();
        for (int i = 0; i < n; ++i) {
            builder.append('0');
        }
        builder.append(str);
    }

    private static void escapeCodePoint(int codePoint, StringBuilder builder) {
        builder.append("\\u");
        Parser.zeroPad(Integer.toHexString(codePoint), builder);
    }

    public static String escape(String str) {
        int len;
        int length = str.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; i += len) {
            int cp = str.codePointAt(i);
            len = Character.charCount(cp);
            if (Parser.isSpecial(cp)) {
                Parser.escapeCodePoint(cp, builder);
                continue;
            }
            builder.appendCodePoint(cp);
        }
        return builder.toString();
    }

    public static String unescape(String str) {
        int length = str.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (length - i <= 5) {
                    builder.append(str.substring(i));
                    i = length;
                    continue;
                }
                if (str.charAt(i + 1) == 'u') {
                    try {
                        int cp = Integer.parseInt(str.substring(i + 2, i + 6), 16);
                        builder.appendCodePoint(cp);
                        i += 5;
                    }
                    catch (NumberFormatException e) {
                        builder.append(c);
                    }
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

