/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.aws;

import com.signalfx.shaded.apache.http.HttpResponse;
import com.signalfx.shaded.apache.http.client.config.RequestConfig;
import com.signalfx.shaded.apache.http.client.methods.HttpGet;
import com.signalfx.shaded.apache.http.impl.client.CloseableHttpClient;
import com.signalfx.shaded.apache.http.impl.client.HttpClientBuilder;
import com.signalfx.shaded.fasterxml.jackson.jr.ob.JSON;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSInstanceInfo {
    public static final String DIMENSION_NAME = "AWSUniqueId";
    private static final String URL = "http://169.254.169.254/latest/dynamic/instance-identity/document";
    private static final Logger log = LoggerFactory.getLogger(AWSInstanceInfo.class);
    private static final String INSTANCE_ID = "instanceId";
    private static final String REGION = "region";
    private static final String ACCOUNT_ID = "accountId";

    public static String get(int timeoutInMs) {
        String string;
        block8: {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeoutInMs).build();
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            HttpGet request = new HttpGet(URL);
            HttpResponse response = client.execute(request);
            InputStream inputStream = response.getEntity().getContent();
            try {
                string = AWSInstanceInfo.parse(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.trace("Exception trying to execute {}, Exception: {} ", (Object)request, (Object)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    static String parse(InputStream inputStream) throws Exception {
        Map<String, Object> result = JSON.std.mapFrom(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return result.get(INSTANCE_ID) + "_" + result.get(REGION) + "_" + result.get(ACCOUNT_ID);
    }

    public static String get() {
        return AWSInstanceInfo.get(1000);
    }
}

