/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.graphql;

import java.time.Duration;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.graphql")
public class GraphQlProperties {
    private String path = "/graphql";
    private final Graphiql graphiql = new Graphiql();
    private final Schema schema = new Schema();
    private final Websocket websocket = new Websocket();
    private final Rsocket rsocket = new Rsocket();
    private final Sse sse = new Sse();

    public Graphiql getGraphiql() {
        return this.graphiql;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Websocket getWebsocket() {
        return this.websocket;
    }

    public Rsocket getRsocket() {
        return this.rsocket;
    }

    public Sse getSse() {
        return this.sse;
    }

    public static class Graphiql {
        private String path = "/graphiql";
        private boolean enabled;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Schema {
        private String[] locations = new String[]{"classpath:graphql/**/"};
        private String[] fileExtensions = new String[]{".graphqls", ".gqls"};
        private final Inspection inspection = new Inspection();
        private final Introspection introspection = new Introspection();
        private final Printer printer = new Printer();

        public String[] getLocations() {
            return this.locations;
        }

        public void setLocations(String[] locations) {
            this.locations = this.appendSlashIfNecessary(locations);
        }

        public String[] getFileExtensions() {
            return this.fileExtensions;
        }

        public void setFileExtensions(String[] fileExtensions) {
            this.fileExtensions = fileExtensions;
        }

        private String[] appendSlashIfNecessary(String[] locations) {
            return (String[])Arrays.stream(locations).map(location -> location.endsWith("/") ? location : location + "/").toArray(String[]::new);
        }

        public Inspection getInspection() {
            return this.inspection;
        }

        public Introspection getIntrospection() {
            return this.introspection;
        }

        public Printer getPrinter() {
            return this.printer;
        }

        public static class Inspection {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class Introspection {
            private boolean enabled = true;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class Printer {
            private boolean enabled;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    public static class Websocket {
        private String path;
        private Duration connectionInitTimeout = Duration.ofSeconds(60L);
        private Duration keepAlive;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Duration getConnectionInitTimeout() {
            return this.connectionInitTimeout;
        }

        public void setConnectionInitTimeout(Duration connectionInitTimeout) {
            this.connectionInitTimeout = connectionInitTimeout;
        }

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }
    }

    public static class Rsocket {
        private String mapping;

        public String getMapping() {
            return this.mapping;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }
    }

    public static class Sse {
        private Duration timeout;

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }
    }
}

