/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.VariableResolverException;

public interface VariableResolver
extends BiFunction<String, GremlinParser.VariableContext, Object> {
    @Override
    public Object apply(String var1, GremlinParser.VariableContext var2);

    public static class DefaultVariableResolver
    implements VariableResolver {
        private final Map<String, Object> variables;

        public DefaultVariableResolver(Map<String, Object> variables) {
            this.variables = variables;
        }

        @Override
        public Object apply(String s, GremlinParser.VariableContext variableContext) {
            if (!this.variables.containsKey(s)) {
                throw new VariableResolverException(String.format("No variable found for %s", s));
            }
            return this.variables.get(s);
        }
    }

    public static class NullVariableResolver
    implements VariableResolver {
        private static NullVariableResolver instance = new NullVariableResolver();

        public static VariableResolver instance() {
            return instance;
        }

        @Override
        public Object apply(String s, GremlinParser.VariableContext variableContext) {
            return null;
        }
    }

    public static class NoVariableResolver
    implements VariableResolver {
        private static NoVariableResolver instance = new NoVariableResolver();

        public static VariableResolver instance() {
            return instance;
        }

        @Override
        public Object apply(String s, GremlinParser.VariableContext variableContext) {
            throw new VariableResolverException(String.format("No variable found for %s", s));
        }
    }
}

