/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.slf4j.Logger;

public class HTTPEntityIDRequestURLBuilder
implements Function<CriteriaSet, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPEntityIDRequestURLBuilder.class);

    @Override
    @Nullable
    public String apply(@Nullable CriteriaSet criteria) {
        EntityIdCriterion criterion;
        EntityIdCriterion entityIdCriterion = criterion = criteria != null ? (EntityIdCriterion)criteria.get(EntityIdCriterion.class) : null;
        if (criterion == null) {
            this.log.trace("Criteria did not contain entity ID, unable to build request URL");
            return null;
        }
        String entityID = criterion.getEntityId();
        if (entityID.toLowerCase().startsWith("http:") || entityID.toLowerCase().startsWith("https:")) {
            this.log.debug("Saw entityID with HTTP/HTTPS URL syntax, returning the entityID itself as request URL");
            return entityID;
        }
        this.log.debug("EntityID was not an HTTP or HTTPS URL, could not construct request URL on that basis");
        return null;
    }
}

