/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletRequest;
import java.util.Enumeration;
import org.apache.myfaces.util.ViewNamespaceUtils;
import org.apache.myfaces.util.lang.AbstractAttributeMap;

public final class RequestParameterMap
extends AbstractAttributeMap<String> {
    private final ServletRequest servletRequest;
    private String viewNamespace;

    RequestParameterMap(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    @Override
    protected String getAttribute(String key) {
        String viewNamespace;
        String value = this.servletRequest.getParameter(key);
        if (value == null && !(viewNamespace = this.getViewNamespace()).isEmpty() && !key.startsWith(viewNamespace)) {
            value = this.servletRequest.getParameter(viewNamespace + key);
        }
        return value;
    }

    protected String getViewNamespace() {
        if (this.viewNamespace == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (context == null) {
                return "";
            }
            this.viewNamespace = ViewNamespaceUtils.getViewNamespace(context, this.servletRequest);
        }
        return this.viewNamespace;
    }

    @Override
    protected void setAttribute(String key, String value) {
        throw new UnsupportedOperationException("Cannot set ServletRequest Parameter");
    }

    @Override
    protected void removeAttribute(String key) {
        throw new UnsupportedOperationException("Cannot remove ServletRequest Parameter");
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        return this.servletRequest.getParameterNames();
    }
}

