/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.page;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.wicket.Application;
import org.apache.wicket.page.CouldNotLockPageException;
import org.apache.wicket.page.IPageLockManager;
import org.apache.wicket.page.PageAccessSynchronizer;
import org.apache.wicket.settings.ExceptionSettings;
import org.apache.wicket.util.LazyInitializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Threads;
import org.apache.wicket.util.time.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageLockManager
implements IPageLockManager {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultPageLockManager.class);
    private final LazyInitializer<ConcurrentMap<Integer, PageAccessSynchronizer.PageLock>> locks = new LazyInitializer<ConcurrentMap<Integer, PageAccessSynchronizer.PageLock>>(){
        private static final long serialVersionUID = 1L;

        protected ConcurrentMap<Integer, PageAccessSynchronizer.PageLock> createInstance() {
            return new ConcurrentHashMap<Integer, PageAccessSynchronizer.PageLock>();
        }
    };
    private final Duration timeout;

    public DefaultPageLockManager(Duration timeout) {
        this.timeout = (Duration)Args.notNull((Object)timeout, (String)"timeout");
    }

    private static long remaining(Instant start, Duration timeout) {
        Duration elapsedTime = Durations.elapsedSince((Instant)start);
        return Math.max(0L, timeout.minus(elapsedTime).toMillis());
    }

    public Duration getTimeout(int pageId) {
        return this.timeout;
    }

    @Override
    public void lockPage(int pageId) throws CouldNotLockPageException {
        Thread thread = Thread.currentThread();
        PageAccessSynchronizer.PageLock lock = new PageAccessSynchronizer.PageLock(pageId, thread);
        Instant start = Instant.now();
        boolean locked = false;
        boolean isDebugEnabled = logger.isDebugEnabled();
        PageAccessSynchronizer.PageLock previous = null;
        Duration pageTimeout = this.getTimeout(pageId);
        while (!locked && Durations.elapsedSince((Instant)start).compareTo(pageTimeout) < 0) {
            if (isDebugEnabled) {
                logger.debug("'{}' attempting to acquire lock to page with id '{}'", (Object)thread.getName(), (Object)pageId);
            }
            if ((previous = ((ConcurrentMap)this.locks.get()).putIfAbsent(pageId, lock)) == null || previous.getThread() == thread) {
                locked = true;
                continue;
            }
            long remaining = DefaultPageLockManager.remaining(start, pageTimeout);
            if (remaining <= 0L) continue;
            previous.waitForRelease(remaining, isDebugEnabled);
        }
        if (locked) {
            if (isDebugEnabled) {
                logger.debug("{} acquired lock to page {}", (Object)thread.getName(), (Object)pageId);
            }
        } else {
            if (logger.isWarnEnabled()) {
                String previousThreadName = previous != null ? previous.getThread().getName() : "N/A";
                logger.warn("Thread '{}' failed to acquire lock to page with id '{}', attempted for {} out of allowed {}. The thread that holds the lock has name '{}'.", new Object[]{thread.getName(), pageId, Duration.between(start, Instant.now()), pageTimeout, previousThreadName});
                if (Application.exists()) {
                    ExceptionSettings.ThreadDumpStrategy strategy = Application.get().getExceptionSettings().getThreadDumpStrategy();
                    switch (strategy) {
                        case ALL_THREADS: {
                            Threads.dumpAllThreads((Logger)logger);
                            break;
                        }
                        case THREAD_HOLDING_LOCK: {
                            Thread previousThread;
                            Thread thread2 = previousThread = previous != null ? previous.getThread() : null;
                            if (previousThread != null) {
                                Threads.dumpSingleThread((Logger)logger, (Thread)previousThread);
                                break;
                            }
                            logger.warn("Cannot dump the stack of the previous thread because it is not available.");
                            break;
                        }
                    }
                }
            }
            throw new CouldNotLockPageException(pageId, thread.getName(), pageTimeout);
        }
    }

    @Override
    public void unlockAllPages() {
        this.internalUnlockPages(null);
    }

    @Override
    public void unlockPage(int pageId) {
        this.internalUnlockPages(pageId);
    }

    private void internalUnlockPages(Integer pageId) {
        Thread thread = Thread.currentThread();
        Iterator pageLockIterator = ((ConcurrentMap)this.locks.get()).values().iterator();
        boolean isDebugEnabled = logger.isDebugEnabled();
        while (pageLockIterator.hasNext()) {
            PageAccessSynchronizer.PageLock lock = (PageAccessSynchronizer.PageLock)pageLockIterator.next();
            if (pageId != null && pageId.intValue() != lock.getPageId() || lock.getThread() != thread) continue;
            pageLockIterator.remove();
            if (isDebugEnabled) {
                logger.debug("'{}' released lock to page with id '{}'", (Object)thread.getName(), (Object)lock.getPageId());
            }
            lock.markReleased(isDebugEnabled);
            if (pageId == null) continue;
            break;
        }
    }

    Supplier<ConcurrentMap<Integer, PageAccessSynchronizer.PageLock>> getLocks() {
        return this.locks;
    }
}

